/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.core.nodetype.ItemDef;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveNodeType
implements Cloneable {
    private static Logger log = LoggerFactory.getLogger((Class)EffectiveNodeType.class);
    private final TreeSet mergedNodeTypes = new TreeSet();
    private final TreeSet inheritedNodeTypes = new TreeSet();
    private final TreeSet allNodeTypes = new TreeSet();
    private final HashMap namedItemDefs = new HashMap();
    private final ArrayList unnamedItemDefs = new ArrayList();

    private EffectiveNodeType() {
    }

    static EffectiveNodeType create(NodeTypeDef ntd, EffectiveNodeTypeCache entCache, Map ntdCache) throws NodeTypeConflictException, NoSuchNodeTypeException {
        EffectiveNodeType ent = new EffectiveNodeType();
        Name ntName = ntd.getName();
        ent.mergedNodeTypes.add(ntName);
        ent.allNodeTypes.add(ntName);
        HashMap<Serializable, ItemDef> itemDefIds = new HashMap<Serializable, ItemDef>();
        NodeDef[] cnda = ntd.getChildNodeDefs();
        for (int i = 0; i < cnda.length; ++i) {
            if (itemDefIds.containsKey(cnda[i].getId())) {
                String msg = cnda[i].definesResidual() ? ntName + " contains ambiguous residual child node definitions" : ntName + " contains ambiguous definitions for child node named " + cnda[i].getName();
                log.debug(msg);
                throw new NodeTypeConflictException(msg);
            }
            itemDefIds.put(cnda[i].getId(), cnda[i]);
            if (cnda[i].definesResidual()) {
                ent.unnamedItemDefs.add(cnda[i]);
                continue;
            }
            Name name = cnda[i].getName();
            ArrayList<NodeDef> defs = (ArrayList<NodeDef>)ent.namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<NodeDef>();
                ent.namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (int j = 0; j < defs.size(); ++j) {
                    ItemDef def = (ItemDef)defs.get(j);
                    if (!cnda[i].isAutoCreated() && !def.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new NodeTypeConflictException(msg);
                }
            }
            defs.add(cnda[i]);
        }
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            if (itemDefIds.containsKey(pda[i].getId())) {
                String msg = pda[i].definesResidual() ? ntName + " contains ambiguous residual property definitions" : ntName + " contains ambiguous definitions for property named " + pda[i].getName();
                log.debug(msg);
                throw new NodeTypeConflictException(msg);
            }
            itemDefIds.put(pda[i].getId(), pda[i]);
            if (pda[i].definesResidual()) {
                ent.unnamedItemDefs.add(pda[i]);
                continue;
            }
            Name name = pda[i].getName();
            ArrayList<PropDef> defs = (ArrayList<PropDef>)ent.namedItemDefs.get(name);
            if (defs == null) {
                defs = new ArrayList<PropDef>();
                ent.namedItemDefs.put(name, defs);
            }
            if (defs.size() > 0) {
                for (int j = 0; j < defs.size(); ++j) {
                    ItemDef def = (ItemDef)defs.get(j);
                    if (!pda[i].isAutoCreated() && !def.isAutoCreated()) continue;
                    String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                    log.debug(msg);
                    throw new NodeTypeConflictException(msg);
                }
            }
            defs.add(pda[i]);
        }
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            EffectiveNodeType base = NodeTypeRegistry.getEffectiveNodeType(supertypes, entCache, ntdCache);
            ent.internalMerge(base, true);
        }
        return ent;
    }

    static EffectiveNodeType create() {
        return new EffectiveNodeType();
    }

    public Name[] getMergedNodeTypes() {
        return this.mergedNodeTypes.toArray(new Name[this.mergedNodeTypes.size()]);
    }

    public Name[] getInheritedNodeTypes() {
        return this.inheritedNodeTypes.toArray(new Name[this.inheritedNodeTypes.size()]);
    }

    public Name[] getAllNodeTypes() {
        return this.allNodeTypes.toArray(new Name[this.allNodeTypes.size()]);
    }

    public ItemDef[] getAllItemDefs() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        ArrayList defs = new ArrayList(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            defs.addAll((List)iter.next());
        }
        defs.addAll(this.unnamedItemDefs);
        if (defs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        return defs.toArray(new ItemDef[defs.size()]);
    }

    public ItemDef[] getNamedItemDefs() {
        if (this.namedItemDefs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        ArrayList defs = new ArrayList(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            defs.addAll((List)iter.next());
        }
        if (defs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        return defs.toArray(new ItemDef[defs.size()]);
    }

    public ItemDef[] getUnnamedItemDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        return this.unnamedItemDefs.toArray(new ItemDef[this.unnamedItemDefs.size()]);
    }

    public boolean hasNamedItemDef(Name name) {
        return this.namedItemDefs.containsKey(name);
    }

    public ItemDef[] getNamedItemDefs(Name name) {
        List defs = (List)this.namedItemDefs.get(name);
        if (defs == null || defs.size() == 0) {
            return ItemDef.EMPTY_ARRAY;
        }
        return defs.toArray(new ItemDef[defs.size()]);
    }

    public NodeDef[] getAllNodeDefs() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        Iterator<Object> iter = this.unnamedItemDefs.iterator();
        while (iter.hasNext()) {
            ItemDef def = (ItemDef)iter.next();
            if (!def.definesNode()) continue;
            defs.add(def);
        }
        iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                ItemDef def = (ItemDef)iter1.next();
                if (!def.definesNode()) continue;
                defs.add(def);
            }
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public NodeDef[] getNamedNodeDefs() {
        if (this.namedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                ItemDef def = (ItemDef)iter1.next();
                if (!def.definesNode()) continue;
                defs.add(def);
            }
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public NodeDef[] getNamedNodeDefs(Name name) {
        List list = (List)this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ItemDef def = (ItemDef)iter.next();
            if (!def.definesNode()) continue;
            defs.add(def);
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public NodeDef[] getUnnamedNodeDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.unnamedItemDefs.size());
        Iterator iter = this.unnamedItemDefs.iterator();
        while (iter.hasNext()) {
            ItemDef def = (ItemDef)iter.next();
            if (!def.definesNode()) continue;
            defs.add(def);
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public NodeDef[] getAutoCreateNodeDefs() {
        if (this.namedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                ItemDef def = (ItemDef)iter1.next();
                if (!def.definesNode() || !def.isAutoCreated()) continue;
                defs.add(def);
            }
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public PropDef[] getAllPropDefs() {
        if (this.namedItemDefs.size() == 0 && this.unnamedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size() + this.unnamedItemDefs.size());
        Iterator<Object> iter = this.unnamedItemDefs.iterator();
        while (iter.hasNext()) {
            ItemDef def = (ItemDef)iter.next();
            if (def.definesNode()) continue;
            defs.add(def);
        }
        iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                ItemDef def = (ItemDef)iter1.next();
                if (def.definesNode()) continue;
                defs.add(def);
            }
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getNamedPropDefs() {
        if (this.namedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                ItemDef def = (ItemDef)iter1.next();
                if (def.definesNode()) continue;
                defs.add(def);
            }
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getNamedPropDefs(Name name) {
        List list = (List)this.namedItemDefs.get(name);
        if (list == null || list.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ItemDef def = (ItemDef)iter.next();
            if (def.definesNode()) continue;
            defs.add(def);
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getUnnamedPropDefs() {
        if (this.unnamedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.unnamedItemDefs.size());
        Iterator iter = this.unnamedItemDefs.iterator();
        while (iter.hasNext()) {
            ItemDef def = (ItemDef)iter.next();
            if (def.definesNode()) continue;
            defs.add(def);
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getAutoCreatePropDefs() {
        if (this.namedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                ItemDef def = (ItemDef)iter1.next();
                if (def.definesNode() || !def.isAutoCreated()) continue;
                defs.add(def);
            }
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public PropDef[] getMandatoryPropDefs() {
        if (this.namedItemDefs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                ItemDef def = (ItemDef)iter1.next();
                if (def.definesNode() || !def.isMandatory()) continue;
                defs.add(def);
            }
        }
        if (defs.size() == 0) {
            return PropDef.EMPTY_ARRAY;
        }
        return defs.toArray(new PropDef[defs.size()]);
    }

    public NodeDef[] getMandatoryNodeDefs() {
        if (this.namedItemDefs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        ArrayList<ItemDef> defs = new ArrayList<ItemDef>(this.namedItemDefs.size());
        Iterator iter = this.namedItemDefs.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            Iterator iter1 = list.iterator();
            while (iter1.hasNext()) {
                ItemDef def = (ItemDef)iter1.next();
                if (!def.definesNode() || !def.isMandatory()) continue;
                defs.add(def);
            }
        }
        if (defs.size() == 0) {
            return NodeDef.EMPTY_ARRAY;
        }
        return defs.toArray(new NodeDef[defs.size()]);
    }

    public boolean includesNodeType(Name nodeTypeName) {
        return this.allNodeTypes.contains(nodeTypeName);
    }

    public boolean includesNodeTypes(Name[] nodeTypeNames) {
        return this.allNodeTypes.containsAll(Arrays.asList(nodeTypeNames));
    }

    public static void checkSetPropertyValueConstraints(PropDef pd, InternalValue[] values) throws ConstraintViolationException, RepositoryException {
        if (!pd.isMultiple() && values != null && values.length > 1) {
            throw new ConstraintViolationException("the property is not multi-valued");
        }
        ValueConstraint[] constraints = pd.getValueConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                boolean satisfied = false;
                ConstraintViolationException cve = null;
                for (int j = 0; j < constraints.length; ++j) {
                    try {
                        constraints[j].check(values[i]);
                        satisfied = true;
                        break;
                    }
                    catch (ConstraintViolationException e) {
                        cve = e;
                        continue;
                    }
                }
                if (satisfied) continue;
                throw cve;
            }
        }
    }

    public void checkAddNodeConstraints(Name name) throws ConstraintViolationException {
        try {
            this.getApplicableChildNodeDef(name, null, null);
        }
        catch (NoSuchNodeTypeException nsnte) {
            String msg = "internal eror: inconsistent node type";
            log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)nsnte);
        }
    }

    public void checkAddNodeConstraints(Name name, Name nodeTypeName, NodeTypeRegistry ntReg) throws ConstraintViolationException, NoSuchNodeTypeException {
        NodeDef nd = this.getApplicableChildNodeDef(name, nodeTypeName, ntReg);
        if (nd.isProtected()) {
            throw new ConstraintViolationException(name + " is protected");
        }
        if (nd.isAutoCreated()) {
            throw new ConstraintViolationException(name + " is auto-created and can not be manually added");
        }
    }

    public NodeDef getApplicableChildNodeDef(Name name, Name nodeTypeName, NodeTypeRegistry ntReg) throws NoSuchNodeTypeException, ConstraintViolationException {
        NodeDef nd;
        EffectiveNodeType entTarget = nodeTypeName != null ? ntReg.getEffectiveNodeType(nodeTypeName) : null;
        ItemDef[] defs = this.getNamedItemDefs(name);
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                ItemDef def = defs[i];
                if (!def.definesNode()) continue;
                nd = (NodeDef)def;
                if (entTarget != null && nd.getRequiredPrimaryTypes() != null) {
                    if (!entTarget.includesNodeTypes(nd.getRequiredPrimaryTypes())) continue;
                    return nd;
                }
                if (nd.getDefaultPrimaryType() == null) continue;
                return nd;
            }
        }
        NodeDef[] nda = this.getUnnamedNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            nd = nda[i];
            if (entTarget != null && nd.getRequiredPrimaryTypes() != null) {
                if (!entTarget.includesNodeTypes(nd.getRequiredPrimaryTypes())) continue;
                return nd;
            }
            if (nd.getDefaultPrimaryType() == null) continue;
            return nd;
        }
        throw new ConstraintViolationException("no matching child node definition found for " + name);
    }

    public PropDef getApplicablePropertyDef(Name name, int type, boolean multiValued) throws ConstraintViolationException {
        PropDef match = this.getMatchingPropDef(this.getNamedPropDefs(name), type, multiValued);
        if (match != null) {
            return match;
        }
        match = this.getMatchingPropDef(this.getUnnamedPropDefs(), type, multiValued);
        if (match != null) {
            return match;
        }
        throw new ConstraintViolationException("no matching property definition found for " + name);
    }

    public PropDef getApplicablePropertyDef(Name name, int type) throws ConstraintViolationException {
        PropDef match = this.getMatchingPropDef(this.getNamedPropDefs(name), type);
        if (match != null) {
            return match;
        }
        match = this.getMatchingPropDef(this.getUnnamedPropDefs(), type);
        if (match != null) {
            return match;
        }
        throw new ConstraintViolationException("no matching property definition found for " + name);
    }

    private PropDef getMatchingPropDef(PropDef[] defs, int type) {
        PropDef match = null;
        for (int i = 0; i < defs.length; ++i) {
            PropDef pd;
            int reqType;
            PropDef def = defs[i];
            if (def.definesNode() || (reqType = (pd = def).getRequiredType()) != 0 && type != 0 && reqType != type) continue;
            if (match == null) {
                match = pd;
            } else if (match.getRequiredType() != pd.getRequiredType()) {
                if (match.getRequiredType() == 0) {
                    match = pd;
                }
            } else if (match.isMultiple() && !pd.isMultiple()) {
                match = pd;
            }
            if (match.getRequiredType() == 0 || match.isMultiple()) continue;
            return match;
        }
        return match;
    }

    private PropDef getMatchingPropDef(PropDef[] defs, int type, boolean multiValued) {
        PropDef match = null;
        for (int i = 0; i < defs.length; ++i) {
            PropDef pd;
            int reqType;
            PropDef def = defs[i];
            if (def.definesNode() || (reqType = (pd = def).getRequiredType()) != 0 && type != 0 && reqType != type || multiValued != pd.isMultiple()) continue;
            if (pd.getRequiredType() != 0) {
                return pd;
            }
            if (match != null) continue;
            match = pd;
        }
        return match;
    }

    public void checkRemoveItemConstraints(Name name) throws ConstraintViolationException {
        ItemDef[] defs = this.getNamedItemDefs(name);
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                if (defs[i].isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory item");
                }
                if (!defs[i].isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected item");
            }
        }
    }

    public void checkRemoveNodeConstraints(Name name) throws ConstraintViolationException {
        NodeDef[] defs = this.getNamedNodeDefs(name);
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                if (defs[i].isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory node");
                }
                if (!defs[i].isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected node");
            }
        }
    }

    public void checkRemovePropertyConstraints(Name name) throws ConstraintViolationException {
        PropDef[] defs = this.getNamedPropDefs(name);
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                if (defs[i].isMandatory()) {
                    throw new ConstraintViolationException("can't remove mandatory property");
                }
                if (!defs[i].isProtected()) continue;
                throw new ConstraintViolationException("can't remove protected property");
            }
        }
    }

    EffectiveNodeType merge(EffectiveNodeType other) throws NodeTypeConflictException {
        EffectiveNodeType copy = (EffectiveNodeType)this.clone();
        copy.internalMerge(other, false);
        return copy;
    }

    private synchronized void internalMerge(EffectiveNodeType other, boolean supertype) throws NodeTypeConflictException {
        String msg;
        ItemDef def;
        int i;
        Name[] nta = other.getAllNodeTypes();
        int includedCount = 0;
        for (int i2 = 0; i2 < nta.length; ++i2) {
            if (!this.includesNodeType(nta[i2])) continue;
            log.debug("node type '" + nta[i2] + "' is already contained.");
            ++includedCount;
        }
        if (includedCount == nta.length) {
            return;
        }
        ItemDef[] defs = other.getNamedItemDefs();
        for (i = 0; i < defs.length; ++i) {
            def = defs[i];
            if (this.includesNodeType(def.getDeclaringNodeType())) continue;
            Name name = def.getName();
            ArrayList<ItemDef> existingDefs = (ArrayList<ItemDef>)this.namedItemDefs.get(name);
            if (existingDefs != null) {
                if (existingDefs.size() > 0) {
                    for (int j = 0; j < existingDefs.size(); ++j) {
                        ItemDef existingDef = (ItemDef)existingDefs.get(j);
                        if (def.isAutoCreated() || existingDef.isAutoCreated()) {
                            msg = "The item definition for '" + name + "' in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existingDef.getDeclaringNodeType() + "': name collision with auto-create definition";
                            log.debug(msg);
                            throw new NodeTypeConflictException(msg);
                        }
                        if (def.definesNode() != existingDef.definesNode()) continue;
                        if (!def.definesNode()) {
                            PropDef pd = (PropDef)def;
                            PropDef epd = (PropDef)existingDef;
                            if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple()) continue;
                            String msg2 = "The property definition for '" + name + "' in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existingDef.getDeclaringNodeType() + "': ambiguous property definition";
                            log.debug(msg2);
                            throw new NodeTypeConflictException(msg2);
                        }
                        msg = "The child node definition for '" + name + "' in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existingDef.getDeclaringNodeType() + "': ambiguous child node definition";
                        log.debug(msg);
                        throw new NodeTypeConflictException(msg);
                    }
                }
            } else {
                existingDefs = new ArrayList<ItemDef>();
                this.namedItemDefs.put(name, existingDefs);
            }
            existingDefs.add(def);
        }
        defs = other.getUnnamedItemDefs();
        for (i = 0; i < defs.length; ++i) {
            def = defs[i];
            if (this.includesNodeType(def.getDeclaringNodeType())) continue;
            Iterator iter = this.unnamedItemDefs.iterator();
            while (iter.hasNext()) {
                ItemDef existing = (ItemDef)iter.next();
                if (def.definesNode() != existing.definesNode()) continue;
                if (!def.definesNode()) {
                    PropDef pd = (PropDef)def;
                    PropDef epd = (PropDef)existing;
                    if (pd.getRequiredType() != epd.getRequiredType() || pd.isMultiple() != epd.isMultiple()) continue;
                    msg = "A property definition in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual property definition";
                    log.debug(msg);
                    throw new NodeTypeConflictException(msg);
                }
                NodeDef nd = (NodeDef)def;
                NodeDef end = (NodeDef)existing;
                if (!Arrays.equals(nd.getRequiredPrimaryTypes(), end.getRequiredPrimaryTypes()) || !(nd.getDefaultPrimaryType() == null ? end.getDefaultPrimaryType() == null : nd.getDefaultPrimaryType().equals(end.getDefaultPrimaryType()))) continue;
                msg = "A child node definition in node type '" + def.getDeclaringNodeType() + "' conflicts with node type '" + existing.getDeclaringNodeType() + "': ambiguous residual child node definition";
                log.debug(msg);
                throw new NodeTypeConflictException(msg);
            }
            this.unnamedItemDefs.add(def);
        }
        for (i = 0; i < nta.length; ++i) {
            this.allNodeTypes.add(nta[i]);
        }
        if (supertype) {
            nta = other.getMergedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.inheritedNodeTypes.add(nta[i]);
            }
            nta = other.getInheritedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.inheritedNodeTypes.add(nta[i]);
            }
        } else {
            nta = other.getMergedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.mergedNodeTypes.add(nta[i]);
            }
            nta = other.getInheritedNodeTypes();
            for (i = 0; i < nta.length; ++i) {
                this.inheritedNodeTypes.add(nta[i]);
            }
        }
    }

    protected Object clone() {
        EffectiveNodeType clone = new EffectiveNodeType();
        clone.mergedNodeTypes.addAll(this.mergedNodeTypes);
        clone.inheritedNodeTypes.addAll(this.inheritedNodeTypes);
        clone.allNodeTypes.addAll(this.allNodeTypes);
        Iterator iter = this.namedItemDefs.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            List list = (List)this.namedItemDefs.get(key);
            clone.namedItemDefs.put(key, new ArrayList(list));
        }
        clone.unnamedItemDefs.addAll(this.unnamedItemDefs);
        return clone;
    }
}

