/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.ZombieHierarchyManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;

class ChangeLogBasedHierarchyMgr
extends HierarchyManagerImpl {
    ZombieHierarchyManager zombieHierMgr;

    ChangeLogBasedHierarchyMgr(NodeId rootNodeId, ItemStateManager manager, ChangeLog changes, PathResolver resolver) {
        super(rootNodeId, new ChangeLogItemStateManager(manager, changes), resolver);
        this.zombieHierMgr = new ZombieHierarchyManager(this, this.provider, new AtticItemStateManager(changes));
    }

    public Path getZombiePath(ItemId id) throws ItemNotFoundException, RepositoryException {
        return this.zombieHierMgr.getPath(id);
    }

    private static class AtticItemStateManager
    implements ItemStateManager {
        private final Map deleted = new HashMap();

        private AtticItemStateManager(ChangeLog changes) {
            Iterator it = changes.deletedStates();
            while (it.hasNext()) {
                ItemState state = (ItemState)it.next();
                this.deleted.put(state.getId(), state);
            }
        }

        public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
            ItemState state = (ItemState)this.deleted.get(id);
            if (state != null) {
                return state;
            }
            throw new NoSuchItemStateException("Item not in the attic: " + id);
        }

        public boolean hasItemState(ItemId id) {
            return this.deleted.containsKey(id);
        }

        public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
            throw new UnsupportedOperationException();
        }

        public boolean hasNodeReferences(NodeReferencesId id) {
            return false;
        }
    }

    private static class ChangeLogItemStateManager
    implements ItemStateManager {
        private final ChangeLog changes;
        private final ItemStateManager base;

        private ChangeLogItemStateManager(ItemStateManager base, ChangeLog changes) {
            this.base = base;
            this.changes = changes;
        }

        public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
            try {
                ItemState state = this.changes.get(id);
                if (state != null) {
                    return state;
                }
            }
            catch (NoSuchItemStateException noSuchItemStateException) {
                // empty catch block
            }
            return this.base.getItemState(id);
        }

        public boolean hasItemState(ItemId id) {
            try {
                ItemState state = this.changes.get(id);
                if (state != null) {
                    return true;
                }
            }
            catch (NoSuchItemStateException noSuchItemStateException) {
                // empty catch block
            }
            return this.base.hasItemState(id);
        }

        public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
            throw new UnsupportedOperationException();
        }

        public boolean hasNodeReferences(NodeReferencesId id) {
            return false;
        }
    }
}

