/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.field.RtfAnchor;
import com.lowagie.text.rtf.graphic.RtfImage;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.table.RtfTable;
import com.lowagie.text.rtf.text.RtfAnnotation;
import com.lowagie.text.rtf.text.RtfChapter;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfNewPage;
import com.lowagie.text.rtf.text.RtfParagraph;
import com.lowagie.text.rtf.text.RtfPhrase;
import com.lowagie.text.rtf.text.RtfSection;
import com.lowagie.text.rtf.text.RtfTab;
import java.util.ArrayList;

public class RtfMapper {
    RtfDocument rtfDoc;

    public RtfMapper(RtfDocument rtfDocument) {
        this.rtfDoc = rtfDocument;
    }

    public RtfBasicElement[] mapElement(Element element) throws DocumentException {
        ArrayList<RtfBasicElement> arrayList = new ArrayList<RtfBasicElement>();
        if (element instanceof RtfBasicElement) {
            RtfBasicElement rtfBasicElement = (RtfBasicElement)element;
            rtfBasicElement.setRtfDocument(this.rtfDoc);
            return new RtfBasicElement[]{rtfBasicElement};
        }
        switch (element.type()) {
            case 10: {
                Chunk chunk = (Chunk)element;
                if (chunk.hasAttributes()) {
                    if (chunk.getAttributes().containsKey("IMAGE")) {
                        arrayList.add(new RtfImage(this.rtfDoc, (Image)chunk.getAttributes().get("IMAGE")));
                        break;
                    }
                    if (chunk.getAttributes().containsKey("NEWPAGE")) {
                        arrayList.add(new RtfNewPage(this.rtfDoc));
                        break;
                    }
                    if (chunk.getAttributes().containsKey("TAB")) {
                        Float f = (Float)((Object[])chunk.getAttributes().get("TAB"))[1];
                        RtfTab rtfTab = new RtfTab(f.floatValue(), 0);
                        rtfTab.setRtfDocument(this.rtfDoc);
                        arrayList.add(rtfTab);
                        arrayList.add(new RtfChunk(this.rtfDoc, new Chunk("\t")));
                        break;
                    }
                    arrayList.add(new RtfChunk(this.rtfDoc, (Chunk)element));
                    break;
                }
                arrayList.add(new RtfChunk(this.rtfDoc, (Chunk)element));
                break;
            }
            case 11: {
                arrayList.add(new RtfPhrase(this.rtfDoc, (Phrase)element));
                break;
            }
            case 12: {
                arrayList.add(new RtfParagraph(this.rtfDoc, (Paragraph)element));
                break;
            }
            case 17: {
                arrayList.add(new RtfAnchor(this.rtfDoc, (Anchor)element));
                break;
            }
            case 29: {
                arrayList.add(new RtfAnnotation(this.rtfDoc, (Annotation)element));
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                arrayList.add(new RtfImage(this.rtfDoc, (Image)element));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                arrayList.add(new RtfInfoElement(this.rtfDoc, (Meta)element));
                break;
            }
            case 14: {
                arrayList.add(new RtfList(this.rtfDoc, (List)element));
                break;
            }
            case 15: {
                arrayList.add(new RtfListItem(this.rtfDoc, (ListItem)element));
                break;
            }
            case 13: {
                arrayList.add(new RtfSection(this.rtfDoc, (Section)element));
                break;
            }
            case 16: {
                arrayList.add(new RtfChapter(this.rtfDoc, (Chapter)element));
                break;
            }
            case 22: {
                try {
                    arrayList.add(new RtfTable(this.rtfDoc, (Table)element));
                    break;
                }
                catch (ClassCastException classCastException) {
                    arrayList.add(new RtfTable(this.rtfDoc, ((SimpleTable)element).createTable()));
                }
            }
        }
        return arrayList.toArray(new RtfBasicElement[arrayList.size()]);
    }
}

