/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.listener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class AnnotationFulltextEventListener
implements EventListener {
    public static final String RELATED_TEXT_PROPERTY = "relatedtext";
    public static final String RELATED_TEXT_ID_PROPERTY = "relatedtextid";
    public static final String RELATED_TEXT_LIST_PROPERTY = "relatedtext:relatedtextresources";
    public static final String ANNOTATION_RESOURCE_ID_PREFIX = "annotation_";

    public void handleEvent(Event event) throws ClientException {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext context = (DocumentEventContext)event.getContext();
        CoreSession session = context.getCoreSession();
        DocumentModel doc = context.getSourceDocument();
        if (doc == null) {
            return;
        }
        if (!doc.hasFacet("HasRelatedText")) {
            return;
        }
        String annotationId = (String)((Object)context.getProperty("annotationId"));
        String annotationBody = (String)((Object)context.getProperty("annotationBody"));
        if ("annotationCreated".equals(event.getName())) {
            this.setAnnotationText(doc, annotationId, annotationBody);
            session.saveDocument(doc);
        } else if ("annotationDeleted".equals(event.getName())) {
            if (this.removeAnnotationText(doc, annotationId)) {
                session.saveDocument(doc);
            }
        } else if ("annotationUpdated".equals(event.getName())) {
            this.removeAnnotationText(doc, annotationId);
            this.setAnnotationText(doc, annotationId, annotationBody);
            session.saveDocument(doc);
        } else if ("documentCheckedIn".equals(event.getName())) {
            DocumentRef versionRef = (DocumentRef)context.getProperty("checkedInVersionRef");
            DocumentModel version = session.getDocument(versionRef);
            if (this.removeAnnotationText(version, null)) {
                session.saveDocument(version);
            }
        } else {
            return;
        }
    }

    protected boolean removeAnnotationText(DocumentModel doc, String annotationId) throws ClientException {
        List relatedResources = (List)doc.getProperty(RELATED_TEXT_LIST_PROPERTY).getValue(List.class);
        String resourceIdToRemove = annotationId == null ? null : AnnotationFulltextEventListener.makeResourceId(annotationId);
        ArrayList<Map> resourcesToRemove = new ArrayList<Map>();
        for (Map resource : relatedResources) {
            String resourceId = (String)resource.get(RELATED_TEXT_ID_PROPERTY);
            if (resourceIdToRemove != null) {
                if (!resourceIdToRemove.equals(resourceId)) continue;
                resourcesToRemove.add(resource);
                continue;
            }
            if (resourceId != null && !resourceId.startsWith(ANNOTATION_RESOURCE_ID_PREFIX)) continue;
            resourcesToRemove.add(resource);
        }
        if (!resourcesToRemove.isEmpty()) {
            relatedResources.removeAll(resourcesToRemove);
            doc.setPropertyValue(RELATED_TEXT_LIST_PROPERTY, (Serializable)((Object)relatedResources));
            return true;
        }
        return false;
    }

    protected void setAnnotationText(DocumentModel doc, String annotationId, String annotationBody) throws ClientException {
        if (annotationBody == null) {
            return;
        }
        try {
            SimpleBlobHolder bh = new SimpleBlobHolder((Blob)new StringBlob(annotationBody, "text/html"));
            ConversionService service = (ConversionService)Framework.getService(ConversionService.class);
            if (service != null) {
                annotationBody = service.convert("html2text", (BlobHolder)bh, null).getBlob().getString();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List relatedResources = (List)doc.getProperty(RELATED_TEXT_LIST_PROPERTY).getValue(List.class);
        HashMap<String, String> resource = new HashMap<String, String>();
        resource.put(RELATED_TEXT_ID_PROPERTY, AnnotationFulltextEventListener.makeResourceId(annotationId));
        resource.put(RELATED_TEXT_PROPERTY, annotationBody);
        relatedResources.add(resource);
        doc.setPropertyValue(RELATED_TEXT_LIST_PROPERTY, (Serializable)((Object)relatedResources));
    }

    public static String makeResourceId(String annotationId) {
        return ANNOTATION_RESOURCE_ID_PREFIX + annotationId;
    }
}

