/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.backend.wss;

import org.nuxeo.ecm.platform.wi.backend.Backend;
import org.nuxeo.ecm.platform.wi.backend.BackendFactory;
import org.nuxeo.ecm.platform.wi.backend.wss.WSSBackendAdapter;
import org.nuxeo.ecm.platform.wi.backend.wss.WSSFakeBackend;
import org.nuxeo.ecm.platform.wi.backend.wss.WSSRootBackendAdapter;
import org.nuxeo.ecm.platform.wi.backend.wss.WSSVirtualBackendAdapter;
import org.nuxeo.ecm.platform.wi.service.PluggableBackendFactory;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSBackendFactory;

public class WSSBackendFactoryImpl
implements WSSBackendFactory {
    private BackendFactory factory = new PluggableBackendFactory();

    public void setFactory(BackendFactory factory) {
        this.factory = factory;
    }

    protected String computeVirtualRoot(WSSRequest request) {
        if (request == null) {
            return "nuxeo";
        }
        String virtualRoot = request.getSitePath();
        if (virtualRoot == null || virtualRoot.equals("")) {
            virtualRoot = request.getHttpRequest().getContextPath();
        }
        if (virtualRoot.startsWith("/")) {
            virtualRoot = virtualRoot.substring(1);
        }
        return virtualRoot;
    }

    public WSSBackend getBackend(WSSRequest wssRequest) {
        Backend backend = null;
        backend = wssRequest != null ? this.factory.getBackend("/", wssRequest.getHttpRequest()) : this.factory.getBackend("/", null);
        if (backend == null) {
            return new WSSFakeBackend();
        }
        String virtualRoot = this.computeVirtualRoot(wssRequest);
        if (backend.isRoot()) {
            return new WSSRootBackendAdapter(backend, virtualRoot);
        }
        if (backend.isVirtual()) {
            return new WSSVirtualBackendAdapter(backend, virtualRoot);
        }
        return new WSSBackendAdapter(backend, virtualRoot);
    }
}

