/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.api.annotations.Cleanup;
import org.jboss.beans.metadata.api.annotations.CleanupOnly;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.plugins.annotations.MetaDataAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ValueUtil;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMetaDataAnnotationPlugin<T extends AnnotatedInfo, C extends Annotation>
extends JBossObject
implements MetaDataAnnotationPlugin<T, C> {
    private Class<C> annotation;
    private Set<ElementType> types;
    private boolean isCleanup;
    private boolean isCleanupOnly;

    protected BaseMetaDataAnnotationPlugin(Class<C> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation!");
        }
        this.annotation = annotation;
        this.types = new HashSet<ElementType>();
        Target target = annotation.getAnnotation(Target.class);
        if (target != null) {
            List<ElementType> list = Arrays.asList(target.value());
            for (ElementType type : list) {
                if (!this.isElementTypeSupported(type)) continue;
                this.types.add(type);
            }
        }
        this.isCleanupOnly = annotation.isAnnotationPresent(CleanupOnly.class);
        this.isCleanup = this.isCleanupOnly || annotation.isAnnotationPresent(Cleanup.class);
    }

    @Override
    public final void applyAnnotation(T info, MetaData retrieval, BeanMetaData beanMetaData) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (!this.isCleanupOnly()) {
            Class<C> annotationClass = this.getAnnotation();
            Annotation annotation = retrieval.getAnnotation(annotationClass);
            if (annotation == null) {
                if (trace) {
                    this.log.trace((Object)("No annotation: " + annotationClass.getName()));
                }
                return;
            }
            if (this.isMetaDataAlreadyPresent(info, annotation, beanMetaData)) {
                if (trace) {
                    this.log.trace((Object)("MetaDataAlreadyPresent, ignoring " + annotation));
                }
                return;
            }
            if (trace) {
                this.log.trace((Object)("Applying annotation: " + annotation));
            }
            this.internalApplyAnnotation(info, retrieval, annotation, beanMetaData);
        } else if (trace) {
            this.log.trace((Object)("Annotation " + this.getAnnotation() + " is @CleanupOnly, nothing to apply on install."));
        }
    }

    protected boolean isMetaDataAlreadyPresent(T info, C annotation, BeanMetaData beanMetaData) {
        return false;
    }

    protected Object internalApplyAnnotation(T info, MetaData retrieval, C annotation, BeanMetaData beanMetaData) throws Throwable {
        return this.internalApplyAnnotation(info, annotation, beanMetaData);
    }

    protected abstract Object internalApplyAnnotation(T var1, C var2, BeanMetaData var3) throws Throwable;

    protected boolean isCleanup() {
        return this.isCleanup;
    }

    protected boolean isCleanupOnly() {
        return this.isCleanupOnly;
    }

    protected static boolean isAttributePresent(String value) {
        return ValueUtil.isAttributePresent(value);
    }

    protected static boolean isAttributePresent(Class<?> value) {
        return ValueUtil.isAttributePresent(value);
    }

    protected abstract boolean isElementTypeSupported(ElementType var1);

    @Override
    public Set<ElementType> getSupportedTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    @Override
    public Class<C> getAnnotation() {
        return this.annotation;
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("@annotation=").append(this.annotation);
        buffer.append(", types=").append(this.types);
        buffer.append(", cleanup=").append(this.isCleanup());
        buffer.append(", cleanupOnly=").append(this.isCleanupOnly());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append("@annotation=").append(this.annotation);
    }
}

