/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.notifier;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.ecm.webengine.notifier.FileChangeListener;
import org.nuxeo.runtime.api.Framework;

public class FileChangeNotifier
implements FileChangeListener {
    private static final Log log = LogFactory.getLog(FileChangeNotifier.class);
    private final ListenerList listeners = new ListenerList();
    private final Timer timer = new Timer("FileChangeNotifier");
    private final Hashtable<String, FileEntry> roots = new Hashtable();

    public void start() {
        String interval = Framework.getProperty((String)"org.nuxeo.ecm.webengine.fileChangeNotifierInterval", (String)"2000");
        this.start(2000, Integer.parseInt(interval));
    }

    public void start(int startAfter, int interval) {
        this.timer.scheduleAtFixedRate((TimerTask)new WatchTask(), startAfter, (long)interval);
    }

    public void stop() {
        this.timer.cancel();
        this.timer.purge();
    }

    public void watch(File file) throws IOException {
        FileEntry entry = new FileEntry(file);
        this.roots.put(entry.file.getPath(), entry);
    }

    public void unwatch(File file) throws IOException {
        this.roots.remove(file.getCanonicalFile().getPath());
    }

    public void addListener(FileChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(FileChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void filesCreated(List<File> entries) {
        for (Object listener : this.listeners.getListeners()) {
            try {
                ((FileChangeListener)listener).filesCreated(entries);
            }
            catch (Throwable t) {
                log.error((Object)("Error while to notifying file creation for: " + entries), t);
            }
        }
    }

    @Override
    public void filesRemoved(List<File> entries) {
        for (Object listener : this.listeners.getListeners()) {
            try {
                ((FileChangeListener)listener).filesRemoved(entries);
            }
            catch (Throwable t) {
                log.error((Object)("Error while to notifying file removal for: " + entries), t);
            }
        }
    }

    @Override
    public void filesModified(List<File> entries) {
        for (Object listener : this.listeners.getListeners()) {
            try {
                ((FileChangeListener)listener).filesModified(entries);
            }
            catch (Throwable t) {
                log.error((Object)("Error while to notifying file change for: " + entries), t);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        FileChangeNotifier fcn = new FileChangeNotifier();
        fcn.watch(new File("/home/bstefanescu/tmp/test"));
        fcn.addListener(new FileChangeListener(){

            @Override
            public void filesModified(List<File> entries) throws Exception {
                System.out.println("FILES CHANGED: " + entries);
            }

            @Override
            public void filesCreated(List<File> entries) throws Exception {
                System.out.println("FILES CREATED: " + entries);
            }

            @Override
            public void filesRemoved(List<File> entries) throws Exception {
                System.out.println("FILES REMOVED: " + entries);
            }
        });
        fcn.start();
        System.out.println("Watching ...");
        Thread.sleep(600000L);
        System.out.println("Done.");
    }

    public class FileEntry
    implements Comparable<FileEntry> {
        public File file;
        public boolean isDirectory;
        public long lastModified;
        public HashMap<File, FileEntry> children;

        public FileEntry(File file) throws IOException {
            File[] files;
            this.file = file.getCanonicalFile();
            this.lastModified = file.lastModified();
            this.isDirectory = file.isDirectory();
            if (this.isDirectory && (files = file.listFiles()) != null) {
                this.children = new HashMap();
                for (File f : files) {
                    this.children.put(f, new FileEntry(f));
                }
            }
        }

        @Override
        public int compareTo(FileEntry o) {
            return this.file.compareTo(o.file);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() == FileEntry.class) {
                return this.file.equals(((FileEntry)obj).file);
            }
            return false;
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public String toString() {
            return this.file.toString();
        }

        public void scanForChanges(List<File> created, List<File> removed, List<File> modified) throws IOException {
            long tm = this.file.lastModified();
            if (tm > this.lastModified) {
                this.lastModified = tm;
                if (this.isDirectory != this.file.isDirectory()) {
                    if (this.isDirectory) {
                        this.isDirectory = false;
                        removed.add(this.file);
                        created.add(this.file);
                    } else {
                        this.isDirectory = true;
                        removed.add(this.file);
                        created.add(this.file);
                    }
                } else if (this.isDirectory) {
                    File[] files;
                    HashSet<File> checkedFiles = new HashSet<File>();
                    for (File f : files = this.file.listFiles()) {
                        checkedFiles.add(f);
                        FileEntry entry = this.children.get(f);
                        if (entry == null) {
                            entry = new FileEntry(f);
                            this.children.put(f, entry);
                            created.add(entry.file);
                            continue;
                        }
                        entry.scanForChanges(created, removed, modified);
                    }
                    Set clone = ((Map)this.children.clone()).keySet();
                    clone.removeAll(checkedFiles);
                    for (File f : clone) {
                        FileEntry entry = this.children.remove(f);
                        removed.add(entry.file);
                    }
                } else {
                    modified.add(this.file);
                }
            }
        }
    }

    class WatchTask
    extends TimerTask {
        WatchTask() {
        }

        @Override
        public void run() {
            try {
                Collection entries = ((Map)FileChangeNotifier.this.roots.clone()).values();
                for (FileEntry entry : entries) {
                    ArrayList<File> removed = new ArrayList<File>();
                    ArrayList<File> created = new ArrayList<File>();
                    ArrayList<File> modified = new ArrayList<File>();
                    entry.scanForChanges(created, removed, modified);
                    if (!removed.isEmpty()) {
                        FileChangeNotifier.this.filesRemoved(removed);
                    }
                    if (!created.isEmpty()) {
                        FileChangeNotifier.this.filesCreated(created);
                    }
                    if (modified.isEmpty()) continue;
                    FileChangeNotifier.this.filesModified(modified);
                }
            }
            catch (Throwable t) {
                log.error((Object)"Error while to notifying file change", t);
            }
        }
    }
}

