/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.core.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.job.executor.JobExecutorThread;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.svc.Services;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.platform.jbpm.core.service.JbpmSynchronization;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoJobExecutorThread
extends JobExecutorThread {
    private static final Log log = LogFactory.getLog(JobExecutorThread.class);
    protected final long maxLockTime;
    protected final JbpmConfiguration jbpmConfiguration;

    public NuxeoJobExecutorThread(String name, JobExecutor jobExecutor, JbpmConfiguration jbpmConfiguration, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(name, jobExecutor, jbpmConfiguration, idleInterval, maxIdleInterval, maxLockTime, maxHistory);
        this.jbpmConfiguration = jbpmConfiguration;
        this.maxLockTime = maxLockTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJob(Job job) {
        TransactionHelper.startTransaction();
        this.getEventService().transactionStarted();
        try {
            JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
            DbPersistenceServiceFactory factory = (DbPersistenceServiceFactory)jbpmContext.getServiceFactory("persistence");
            boolean jbpmTransaction = factory.isTransactionEnabled();
            if (!jbpmTransaction) {
                jbpmContext.getSession().getTransaction().registerSynchronization((Synchronization)new JbpmSynchronization(jbpmContext));
            }
            try {
                JobSession jobSession = jbpmContext.getJobSession();
                job = jobSession.loadJob(job.getId());
                try {
                    log.debug((Object)("executing " + job));
                    if (job.execute(jbpmContext)) {
                        jobSession.deleteJob(job);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)("exception while executing " + job), (Throwable)e);
                    if (e instanceof HibernateException) {
                        StringWriter memoryWriter = new StringWriter();
                        e.printStackTrace(new PrintWriter(memoryWriter));
                        job.setException(memoryWriter.toString());
                        job.setRetries(job.getRetries() - 1);
                    }
                    jbpmContext.setRollbackOnly();
                }
                long totalLockTimeInMillis = System.currentTimeMillis() - job.getLockTime().getTime();
                if (totalLockTimeInMillis > this.maxLockTime) {
                    jbpmContext.setRollbackOnly();
                }
            }
            finally {
                try {
                    if (jbpmTransaction) {
                        jbpmContext.close();
                        this.getEventService().transactionCommitted();
                    }
                }
                catch (JbpmPersistenceException e) {
                    if (Services.isCausedByStaleState((JbpmPersistenceException)e)) {
                        log.debug((Object)("optimistic locking failed, couldn't complete job " + job));
                    }
                    throw e;
                }
            }
        }
        catch (Throwable t) {
            TransactionHelper.setTransactionRollbackOnly();
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    private EventService getEventService() {
        try {
            return (EventService)Framework.getService(EventService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection acquireJobs() {
        TransactionHelper.startTransaction();
        Collection acquiredJobs = null;
        try {
            acquiredJobs = super.acquireJobs();
        }
        catch (Throwable t) {
            TransactionHelper.setTransactionRollbackOnly();
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
        }
        return acquiredJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getNextDueDate() {
        TransactionHelper.startTransaction();
        Date date = null;
        try {
            date = super.getNextDueDate();
        }
        catch (Throwable t) {
            TransactionHelper.setTransactionRollbackOnly();
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
        }
        return date;
    }
}

