/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.scheduler.core;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EventJob
implements Job {
    private static final Log log = LogFactory.getLog(EventJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        ClassLoader nuxeoCL = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(nuxeoCL);
            this.execute(dataMap);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(JobDataMap dataMap) throws Exception {
        String eventId = dataMap.getString("eventId");
        String eventCategory = dataMap.getString("eventCategory");
        String username = dataMap.getString("username");
        EventService eventService = (EventService)Framework.getService(EventService.class);
        if (eventService == null) {
            log.error((Object)"Cannot find EventService");
            return;
        }
        LoginContext loginContext = null;
        try {
            loginContext = username == null ? Framework.login() : NuxeoAuthenticationFilter.loginAs((String)username);
            UserPrincipal principal = new UserPrincipal(username, null, false, false);
            EventContextImpl eventContext = new EventContextImpl(null, (Principal)principal);
            eventContext.setProperty("category", (Serializable)((Object)eventCategory));
            eventContext.setProperties((Map)dataMap);
            EventImpl event = new EventImpl(eventId, (EventContext)eventContext);
            TransactionHelper.startTransaction();
            log.info((Object)("Sending scheduled event id=" + eventId + ", category=" + eventCategory + ", username=" + username));
            eventService.fireEvent((Event)event);
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }
}

