/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.DownloadingPackageSource;
import org.nuxeo.connect.packages.InternalPackageManager;
import org.nuxeo.connect.packages.LocalPackageSource;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.RemotePackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.DependencyResolver;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.VersionRange;
import org.nuxeo.connect.update.task.Task;

public class PackageManagerImpl
implements PackageManager,
InternalPackageManager {
    protected static final Log log = LogFactory.getLog(PackageManagerImpl.class);
    protected List<PackageSource> localSources = new ArrayList<PackageSource>();
    protected List<PackageSource> remoteSources = new ArrayList<PackageSource>();
    protected List<String> sourcesNames = new ArrayList<String>();
    protected Map<String, DownloadablePackage> cachedPackageList = null;
    protected DependencyResolver resolver;

    protected List<PackageSource> getAllSources() {
        ArrayList<PackageSource> allSources = new ArrayList<PackageSource>();
        allSources.addAll(this.remoteSources);
        allSources.addAll(this.localSources);
        return allSources;
    }

    public PackageManagerImpl() {
        this.registerSource(new RemotePackageSource(), false);
        this.registerSource(new DownloadingPackageSource(), true);
        this.registerSource(new LocalPackageSource(), true);
        this.resolver = new DependencyResolver(this);
    }

    public void resetSources() {
        this.localSources.clear();
        this.remoteSources.clear();
        this.sourcesNames.clear();
        if (this.cachedPackageList != null) {
            this.cachedPackageList.clear();
        }
    }

    protected List<DownloadablePackage> doMergePackages(List<PackageSource> sources, PackageType type) {
        HashMap<String, DownloadablePackage> packagesById = new HashMap<String, DownloadablePackage>();
        for (PackageSource source : sources) {
            List<DownloadablePackage> packages = null;
            packages = type == null ? source.listPackages() : source.listPackages(type);
            for (DownloadablePackage pkg : packages) {
                packagesById.put(pkg.getId(), pkg);
            }
        }
        ArrayList allPackages = new ArrayList();
        allPackages.addAll(packagesById.values());
        HashMap<String, DownloadablePackage> packagesByName = new HashMap<String, DownloadablePackage>();
        for (DownloadablePackage pkg : allPackages) {
            String name = pkg.getName();
            if (packagesByName.containsKey(name)) {
                DownloadablePackage other = (DownloadablePackage)packagesByName.get(name);
                if (!pkg.getVersion().greaterThan(other.getVersion())) continue;
                packagesByName.put(name, pkg);
                continue;
            }
            packagesByName.put(name, pkg);
        }
        ArrayList<DownloadablePackage> resPackages = new ArrayList<DownloadablePackage>();
        resPackages.addAll(packagesByName.values());
        return resPackages;
    }

    @Override
    public List<DownloadablePackage> findRemotePackages(String packageName) {
        ArrayList<DownloadablePackage> pkgs = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.remoteSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(packageName)) continue;
                pkgs.add(pkg);
            }
        }
        return pkgs;
    }

    @Override
    public List<Version> findLocalPackageVersions(String packageName) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(packageName)) continue;
                versions.add(pkg.getVersion());
            }
        }
        return versions;
    }

    @Override
    public DownloadablePackage findPackageById(String packageId) {
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getId().equals(packageId)) continue;
                return pkg;
            }
        }
        for (PackageSource source : this.remoteSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getId().equals(packageId)) continue;
                return pkg;
            }
        }
        return null;
    }

    @Override
    public List<Version> getPreferedVersions(String pkgName) {
        ArrayList<Version> versions = new ArrayList<Version>();
        ArrayList<Version> installedVersions = new ArrayList<Version>();
        ArrayList<Version> localVersions = new ArrayList<Version>();
        ArrayList<Version> remoteVersions = new ArrayList<Version>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(pkgName)) continue;
                if (pkg.getState() == 4) {
                    installedVersions.add(pkg.getVersion());
                    continue;
                }
                localVersions.add(pkg.getVersion());
            }
        }
        for (PackageSource source : this.remoteSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(pkgName)) continue;
                remoteVersions.add(pkg.getVersion());
            }
        }
        Collections.sort(localVersions);
        Collections.sort(remoteVersions);
        versions.addAll(installedVersions);
        versions.addAll(localVersions);
        versions.addAll(remoteVersions);
        return versions;
    }

    @Override
    public List<Version> getAvailableVersion(String pkgName, VersionRange range, String targetPlatform) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (PackageSource source : this.getAllSources()) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(pkgName) || !range.matchVersion(pkg.getVersion()) || !TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg, targetPlatform) || versions.contains(pkg.getVersion())) continue;
                versions.add(pkg.getVersion());
            }
        }
        return versions;
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        return this.doMergePackages(this.getAllSources(), null);
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        return this.doMergePackages(this.getAllSources(), type);
    }

    @Override
    public List<DownloadablePackage> searchPackages(String searchExpr) {
        return null;
    }

    @Override
    public void registerSource(PackageSource source, boolean local) {
        String name = source.getName();
        if (!this.sourcesNames.contains(name)) {
            if (local) {
                this.localSources.add(source);
            } else {
                this.remoteSources.add(source);
            }
        }
    }

    @Override
    public List<DownloadablePackage> listInstalledPackages() {
        ArrayList<DownloadablePackage> res = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (pkg.getState() < 3) continue;
                res.add(pkg);
            }
        }
        return res;
    }

    @Override
    public List<DownloadablePackage> listRemotePackages() {
        return this.doMergePackages(this.remoteSources, null);
    }

    @Override
    public List<DownloadablePackage> listRemotePackages(PackageType type) {
        return this.doMergePackages(this.remoteSources, type);
    }

    @Override
    public List<DownloadablePackage> listLocalPackages() {
        return this.listLocalPackages(null);
    }

    @Override
    public List<DownloadablePackage> listLocalPackages(PackageType type) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        ArrayList<String> pkgIds = new ArrayList<String>();
        for (PackageSource source : this.localSources) {
            List<DownloadablePackage> pkgs = null;
            pkgs = type == null ? source.listPackages() : source.listPackages(type);
            for (DownloadablePackage pkg : pkgs) {
                if (pkgIds.contains(pkg.getId())) continue;
                pkgIds.add(pkg.getId());
                result.add(pkg);
            }
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages() {
        return this.listUpdatePackages(null);
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages(PackageType type) {
        List<DownloadablePackage> localPackages = this.doMergePackages(this.localSources, type);
        List<DownloadablePackage> localPackages2 = this.listLocalPackages(type);
        List<DownloadablePackage> remotePackages = this.listRemotePackages(type);
        ArrayList<DownloadablePackage> toUpdate = new ArrayList<DownloadablePackage>();
        ArrayList<String> toUpdateIds = new ArrayList<String>();
        block0: for (DownloadablePackage pkg : localPackages) {
            for (DownloadablePackage remotePkg : remotePackages) {
                if (!remotePkg.getName().equals(pkg.getName())) continue;
                if (remotePkg.getVersion() != null) {
                    if (remotePkg.getVersion().greaterThan(pkg.getVersion())) {
                        toUpdate.add(remotePkg);
                        toUpdateIds.add(remotePkg.getId());
                        continue block0;
                    }
                    if (!remotePkg.getVersion().equals(pkg.getVersion()) || pkg.getState() != 1 && pkg.getState() != 2 && pkg.getState() != 3) continue block0;
                    toUpdate.add(pkg);
                    toUpdateIds.add(pkg.getId());
                    continue block0;
                }
                log.warn((Object)("Package " + remotePkg.getId() + " has a null version"));
                continue block0;
            }
        }
        if (type == null || type == PackageType.HOT_FIX) {
            List<DownloadablePackage> hotFixes = this.listRemotePackages(PackageType.HOT_FIX);
            for (DownloadablePackage pkg : hotFixes) {
                if (toUpdateIds.contains(pkg.getId())) continue;
                boolean alreadyInLocal = false;
                for (DownloadablePackage lpkg : localPackages) {
                    if (!lpkg.getName().equals(pkg.getName())) continue;
                    if (!lpkg.getVersion().greaterOrEqualThan(pkg.getVersion())) break;
                    alreadyInLocal = true;
                    break;
                }
                if (alreadyInLocal) continue;
                toUpdate.add(0, pkg);
            }
        }
        return toUpdate;
    }

    @Override
    public DownloadingPackage download(String packageId) throws Exception {
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        return crs.getConnector().getDownload(packageId);
    }

    @Override
    public void install(String packageId, Map<String, String> params) throws Exception {
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        if (pus == null) {
            if (!NuxeoConnectClient.isTestModeSet()) {
                log.error((Object)"Can not locate PackageUpdateService, exiting");
            }
            return;
        }
        LocalPackage pkg = pus.getPackage(packageId);
        Task installationTask = pkg.getInstallTask();
        installationTask.validate();
        installationTask.run(params);
    }

    protected void invalidateCache() {
        this.cachedPackageList = null;
    }

    protected Map<String, DownloadablePackage> getCachedPackageList() {
        if (this.cachedPackageList == null) {
            this.cachedPackageList = new HashMap<String, DownloadablePackage>();
        }
        for (DownloadablePackage pkg : this.listPackages()) {
            this.cachedPackageList.put(pkg.getId(), pkg);
        }
        return this.cachedPackageList;
    }

    protected DownloadablePackage getPkgInList(List<DownloadablePackage> pkgs, String pkgId) {
        for (DownloadablePackage pkg : pkgs) {
            if (!pkgId.equals(pkg.getId())) continue;
            return pkg;
        }
        return null;
    }

    public DownloadablePackage getLocalPackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listLocalPackages();
        return this.getPkgInList(pkgs, pkgId);
    }

    public DownloadablePackage getRemotePackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listRemotePackages();
        return this.getPkgInList(pkgs, pkgId);
    }

    public DownloadablePackage resolvePackage(String pkgId) {
        return null;
    }

    @Override
    public DownloadablePackage getPackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listPackages();
        DownloadablePackage pkg = this.getPkgInList(pkgs, pkgId);
        if (pkg == null) {
            List<DownloadablePackage> studioPkgs = this.listAllStudioRemotePackages();
            pkg = this.getPkgInList(studioPkgs, pkgId);
        }
        return pkg;
    }

    @Override
    public List<DownloadablePackage> listRemoteOrLocalPackages() {
        return this.listRemoteOrLocalPackages(null);
    }

    @Override
    public List<DownloadablePackage> listRemoteOrLocalPackages(PackageType type) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        List<DownloadablePackage> all = this.listPackages(type);
        List<DownloadablePackage> remotes = this.listRemotePackages(type);
        block0: for (DownloadablePackage pkg : all) {
            for (DownloadablePackage remote : remotes) {
                if (!remote.getName().equals(pkg.getName())) continue;
                result.add(pkg);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listAllStudioRemoteOrLocalPackages() {
        List<DownloadablePackage> remote = this.listAllStudioRemotePackages();
        List<DownloadablePackage> local = this.listLocalPackages(PackageType.STUDIO);
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : remote) {
            boolean found = false;
            for (DownloadablePackage lpkg : local) {
                if (!lpkg.getId().equals(pkg.getId())) continue;
                result.add(lpkg);
                found = true;
                break;
            }
            if (found) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listOnlyRemotePackages() {
        return this.listOnlyRemotePackages(null);
    }

    @Override
    public List<DownloadablePackage> listOnlyRemotePackages(PackageType type) {
        List<DownloadablePackage> result = this.listRemotePackages(type);
        List<DownloadablePackage> local = this.listLocalPackages(type);
        block0: for (DownloadablePackage pkg : local) {
            for (DownloadablePackage remote : result) {
                if (!remote.getName().equals(pkg.getName())) continue;
                result.remove(remote);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listAllStudioRemotePackages() {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.remoteSources) {
            List<DownloadablePackage> packages = source.listPackages(PackageType.STUDIO);
            result.addAll(packages);
        }
        return result;
    }

    @Override
    public void flushCache() {
        for (PackageSource source : this.getAllSources()) {
            source.flushCache();
        }
    }

    @Override
    public DependencyResolution resolveDependencies(String pkgId, String targetPlatform) {
        try {
            return this.resolver.resolve(pkgId, targetPlatform);
        }
        catch (DependencyException e) {
            return new DependencyResolution(e);
        }
    }
}

