/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
@SuppressWarnings("serial")
public class FileChanges implements Serializable {
    protected List<FileRef> added;

    protected List<FileRef> removed;

    public FileChanges() {
        added = new ArrayList<FileRef>();
        removed = new ArrayList<FileRef>();
    }

    public List<FileRef> getAddedFiles() {
        return added;
    }

    public List<FileRef> getRemovedFiles() {
        return removed;
    }

    void fileAdded(FileRef ref) {
        added.add(ref);
    }

    void fileRemoved(FileRef ref) {
        added.remove(ref);
        removed.add(ref);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (FileRef ref : added) {
            buf.append('+').append(ref.getId()).append('\n');
        }
        for (FileRef ref : removed) {
            buf.append('-').append(ref.getId()).append('\n');
        }
        return buf.toString();
    }
}
