/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.update;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.AbstractTask;
import org.nuxeo.connect.update.impl.task.commands.AbstractCommand;
import org.nuxeo.connect.update.impl.task.commands.Command;
import org.nuxeo.connect.update.impl.task.update.RollbackOptions;
import org.nuxeo.connect.update.impl.task.update.UpdateManager;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.task.Task;
import org.w3c.dom.Element;

public class Rollback
extends AbstractCommand {
    protected static final Log log = LogFactory.getLog(Rollback.class);
    public static String ID = "rollback";
    protected String key;
    protected String version;
    protected boolean deleteOnExit;

    public Rollback() {
        super(ID);
    }

    public Rollback(RollbackOptions opt) {
        super(ID);
        this.key = opt.key;
        this.version = opt.version;
        this.deleteOnExit = opt.deleteOnExit;
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.version != null) {
            writer.attr("version", this.version);
        }
        if (this.key != null) {
            writer.attr("key", this.key);
        }
        if (this.deleteOnExit) {
            writer.attr("deleteOnExit", "true");
        }
        writer.end();
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("version");
        if (v.length() > 0) {
            this.version = v;
        }
        if ((v = element.getAttribute("key")).length() > 0) {
            this.key = v;
        }
        if ((v = element.getAttribute("deleteOnExit")).length() > 0) {
            this.deleteOnExit = Boolean.parseBoolean(v);
        }
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.key == null || this.version == null) {
            status.addError("Cannot execute command in installer. Invalid rollback syntax: key or version was not specified.");
        }
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        UpdateManager mgr = ((AbstractTask)task).getUpdateManager();
        RollbackOptions opt = mgr.createRollbackOptions(task.getPackage().getId(), this.key, this.version);
        opt.setDeleteOnExit(this.deleteOnExit);
        mgr.rollback(opt);
        return null;
    }
}

