/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.backend;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.wi.backend.Backend;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractCoreBackend
implements Backend {
    protected CoreSession session;

    public AbstractCoreBackend() {
    }

    protected AbstractCoreBackend(CoreSession session) {
        this.session = session;
    }

    @Override
    public CoreSession getSession() throws ClientException {
        return this.getSession(false);
    }

    @Override
    public CoreSession getSession(boolean synchronize) throws ClientException {
        try {
            if (this.session == null) {
                RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
                this.session = rm.getDefaultRepository().open();
            } else {
                this.session.save();
            }
        }
        catch (Exception e) {
            throw new ClientException("Error while getting session", (Throwable)e);
        }
        if (synchronize) {
            this.session.save();
        }
        return this.session;
    }

    @Override
    public void setSession(CoreSession session) {
        this.session = session;
    }

    @Override
    public void destroy() {
        this.close();
    }

    protected void close() {
        if (this.session != null) {
            CoreInstance.getInstance().close(this.session);
            this.session = null;
        }
    }

    @Override
    public void discardChanges() throws ClientException {
        this.discardChanges(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardChanges(boolean release) throws ClientException {
        block5: {
            if (this.session == null) break block5;
            try {
                this.session.cancel();
                if (release) {
                    this.close();
                }
            }
            catch (Exception e) {
                throw new ClientException("Error during discard", (Throwable)e);
            }
        }
    }

    @Override
    public void saveChanges() throws ClientException {
        this.saveChanges(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges(boolean release) throws ClientException {
        block5: {
            if (this.session == null) break block5;
            try {
                this.session.save();
                if (release) {
                    this.close();
                }
            }
            catch (ClientException e) {
                throw new ClientException("Error during save", e);
            }
        }
    }
}

