/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.backend.webdav;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.wi.backend.Backend;
import org.nuxeo.ecm.webdav.backend.WebDavBackend;

public class WebDavBackendAdapter
implements WebDavBackend {
    private static final Log log = LogFactory.getLog(WebDavBackendAdapter.class);
    private Backend backend;

    public WebDavBackendAdapter(Backend backend) {
        this.backend = backend;
    }

    public void saveChanges() throws ClientException {
        this.backend.saveChanges();
    }

    public void discardChanges() throws ClientException {
        this.backend.discardChanges();
    }

    public boolean isLocked(DocumentRef ref) throws ClientException {
        return this.backend.isLocked(ref);
    }

    public boolean canUnlock(DocumentRef ref) throws ClientException {
        return this.backend.canUnlock(ref);
    }

    public String lock(DocumentRef ref) throws ClientException {
        return this.backend.lock(ref);
    }

    public boolean unlock(DocumentRef ref) throws ClientException {
        return this.backend.unlock(ref);
    }

    public String getCheckoutUser(DocumentRef ref) throws ClientException {
        return this.backend.getCheckoutUser(ref);
    }

    public Path parseLocation(String location) {
        return this.backend.parseLocation(location);
    }

    public DocumentModel resolveLocation(String location) throws ClientException {
        return this.backend.resolveLocation(location);
    }

    public void removeItem(String location) throws ClientException {
        this.backend.removeItem(location);
    }

    public void removeItem(DocumentRef ref) throws ClientException {
        this.backend.removeItem(ref);
    }

    public void renameItem(DocumentModel source, String destinationName) throws ClientException {
        this.backend.renameItem(source, destinationName);
    }

    public DocumentModel moveItem(DocumentModel source, PathRef targetParentRef) throws ClientException {
        return this.backend.moveItem(source, targetParentRef);
    }

    public DocumentModel copyItem(DocumentModel source, PathRef targetParentRef) throws ClientException {
        return this.backend.copyItem(source, targetParentRef);
    }

    public DocumentModel createFolder(String parentPath, String name) throws ClientException {
        return this.backend.createFolder(parentPath, name);
    }

    public DocumentModel createFile(String parentPath, String name, Blob content) throws ClientException {
        return this.backend.createFile(parentPath, name, content);
    }

    public DocumentModel createFile(String parentPath, String name) throws ClientException {
        return this.backend.createFile(parentPath, name);
    }

    public DocumentModel updateDocument(DocumentModel documentModel, String s, Blob blob) throws ClientException {
        return this.backend.updateDocument(documentModel, s, blob);
    }

    public List<DocumentModel> getChildren(DocumentRef ref) throws ClientException {
        return this.backend.getChildren(ref);
    }

    public boolean isRename(String source, String destination) {
        return this.backend.isRename(source, destination);
    }

    public boolean exists(String location) {
        return this.backend.exists(location);
    }

    public boolean hasPermission(DocumentRef documentRef, String s) throws ClientException {
        return this.backend.hasPermission(documentRef, s);
    }

    public String getDisplayName(DocumentModel doc) {
        return this.backend.getDisplayName(doc);
    }

    public LinkedList<String> getVirtualFolderNames() throws ClientException {
        return this.backend.getVirtualFolderNames();
    }

    public boolean isVirtual() {
        return this.backend.isVirtual();
    }

    public DocumentModel getDocument(String location) throws ClientException {
        try {
            return this.backend.getDocument(location);
        }
        catch (ClientRuntimeException e) {
            log.warn((Object)e);
            return null;
        }
    }
}

