/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.filter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.ecm.platform.wi.backend.Backend;
import org.nuxeo.ecm.platform.wi.filter.WISession;

public class SessionCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String COMMA_SEPARATOR = ",";
    protected static final String EQUAL_SEPARATOR = "=";
    protected static final String QUOTE = "\"";
    private Map<String, WISession> map = new ConcurrentHashMap<String, WISession>();

    public WISession get(HttpServletRequest httpRequest) {
        String key = this.getKey(httpRequest);
        return this.get(key);
    }

    public WISession get(String key) {
        if (StringUtils.isEmpty((String)key)) {
            WISession session = new WISession(key);
            return session;
        }
        WISession session = this.map.get(key);
        if (session == null) {
            session = new WISession(key);
            this.put(session);
            return session;
        }
        if (session.isValid()) {
            session.access();
            return session;
        }
        Backend backend = (Backend)session.getAttribute("org.nuxeo.ecm.platform.wi.backend");
        if (backend != null) {
            backend.destroy();
        }
        session = new WISession(key);
        this.put(session);
        return session;
    }

    public void put(WISession session) {
        this.map.put(session.getKey(), session);
    }

    public void invalidateCache() {
        for (WISession session : this.map.values()) {
            session.invalid();
        }
    }

    private String getKey(HttpServletRequest httpRequest) {
        int idx;
        String b64userpassword;
        byte[] clearUp;
        String userpassword;
        String[] up;
        HttpSession session = httpRequest.getSession(false);
        if (session != null) {
            return session.getId();
        }
        String header = httpRequest.getHeader("Authorization");
        if (StringUtils.isEmpty((String)header)) {
            return "";
        }
        String username = null;
        if (header.toLowerCase().startsWith("digest")) {
            int idx2 = header.indexOf(32);
            Map<String, String> headerMap = this.splitResponseParameters(header.substring(idx2 + 1));
            username = headerMap.get("username");
        } else if (header.toLowerCase().startsWith("basic") && (up = (userpassword = new String(clearUp = Base64.decode((String)(b64userpassword = header.substring((idx = header.indexOf(32)) + 1))))).split(":")).length == 2) {
            username = up[0];
        }
        if (StringUtils.isNotEmpty(username)) {
            return username;
        }
        return "";
    }

    private Map<String, String> splitResponseParameters(String auth) {
        String[] array = auth.split(COMMA_SEPARATOR);
        if (array == null || array.length == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : array) {
            String[] parts = (item = StringUtils.replace((String)item, (String)QUOTE, (String)"")).split(EQUAL_SEPARATOR);
            if (parts == null) continue;
            map.put(parts[0].trim(), item.substring(parts[0].length() + 1));
        }
        return map;
    }
}

