/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.deployment.NuxeoStarter;
import org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PackWar {
    private static Log log = LogFactory.getLog(PackWar.class);
    private static final List<String> MISSING_WEBINF_LIBS = Arrays.asList("mail", "freemarker");
    private static final List<String> MISSING_LIBS = Arrays.asList("nuxeo-generic-wss-front", "log4j", "commons-logging", "commons-lang", "derby", "h2", "ojdbc", "postgresql", "mysql-connector-java", "nuxeo-core-storage-sql-extensions", "lucene");
    private static final List<String> ENDORSED_LIBS = Arrays.asList("jaxb-api", "jaxws-api");
    private static final String ZIP_ENDORSED = "endorsed/";
    private static final String ZIP_LIB = "lib/";
    private static final String ZIP_WEBAPPS_NUXEO = "webapps/nuxeo/";
    private static final String ZIP_WEBINF = "webapps/nuxeo/WEB-INF/";
    private static final String ZIP_WEBINF_LIB = "webapps/nuxeo/WEB-INF/lib/";
    private static final String ZIP_README = "README-NUXEO.txt";
    private static final String README_BEGIN = "This ZIP must be uncompressed at the root of your Tomcat instance.\n\nIn order for Nuxeo to run, the following Resource defining your JDBC datasource configuration\nmust be added inside the <GlobalNamingResources> section of the file conf/server.xml\n\n  ";
    private static final String README_END = "\n\nMake sure that the 'url' attribute above is correct.\nNote that the following file also contains database configuration:\n\n  webapps/nuxeo/WEB-INF/default-repository-config.xml\n\nAlso note that you should start Tomcat with more memory than its default, for instance:\n\n  JAVA_OPTS=\"-Xms512m -Xmx1024m -XX:MaxPermSize=512m\" bin/catalina.sh start\n\n";
    private static final String COMMAND_PREPROCESSING = "preprocessing";
    private static final String COMMAND_PACKAGING = "packaging";
    protected File nxserver;
    protected File tomcat;
    protected File zip;

    public PackWar(File nxserver, File zip) {
        if (!nxserver.isDirectory() || !nxserver.getName().equals("nxserver")) {
            PackWar.fail("No nxserver found at " + nxserver);
        }
        if (zip.exists()) {
            PackWar.fail("Target ZIP file " + zip + " already exists");
        }
        this.nxserver = nxserver;
        this.tomcat = nxserver.getParentFile();
        this.zip = zip;
    }

    public void execute(String command) throws Exception {
        boolean packaging;
        boolean preprocessing = COMMAND_PREPROCESSING.equals(command) || StringUtils.isBlank((String)command);
        boolean bl = packaging = COMMAND_PACKAGING.equals(command) || StringUtils.isBlank((String)command);
        if (!preprocessing && !packaging) {
            PackWar.fail("Command parameter should be empty or preprocessing or packaging");
        }
        if (preprocessing) {
            this.executePreprocessing();
        }
        if (packaging) {
            this.executePackaging();
        }
    }

    protected void executePreprocessing() throws Exception {
        this.runTemplatePreprocessor();
        this.runDeploymentPreprocessor();
    }

    protected void runTemplatePreprocessor() throws Exception {
        if (System.getProperty("nuxeo.home") == null) {
            System.setProperty("nuxeo.home", this.tomcat.getAbsolutePath());
        }
        if (System.getProperty("nuxeo.conf") == null) {
            System.setProperty("nuxeo.conf", new File(this.tomcat, "bin/nuxeo.conf").getPath());
        }
        new ConfigurationGenerator().run();
    }

    protected void runDeploymentPreprocessor() throws Exception {
        DeploymentPreprocessor processor = new DeploymentPreprocessor(this.nxserver);
        processor.init();
        processor.predeploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePackaging() throws IOException {
        FileOutputStream out = new FileOutputStream(this.zip);
        ZipOutputStream zout = new ZipOutputStream(out);
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(README_BEGIN.getBytes("UTF-8"));
            ServerXmlProcessor.INSTANCE.process(PackWar.newFile(this.tomcat, "conf/server.xml"), bout);
            bout.write(README_END.getBytes("UTF-8"));
            this.zipBytes(ZIP_README, bout.toByteArray(), zout);
            File nuxeoXml = PackWar.newFile(this.tomcat, "conf/Catalina/localhost/nuxeo.xml");
            this.zipFile("webapps/nuxeo/META-INF/context.xml", nuxeoXml, zout, NuxeoXmlProcessor.INSTANCE);
            this.zipTree(ZIP_WEBAPPS_NUXEO, new File(this.nxserver, "nuxeo.war"), false, zout);
            this.zipTree(ZIP_WEBINF, new File(this.nxserver, "config"), false, zout);
            this.zipTree(ZIP_WEBINF_LIB, new File(this.nxserver, "bundles"), false, zout);
            this.zipTree(ZIP_WEBINF_LIB, new File(this.nxserver, "lib"), false, zout);
            this.zipLibs(ZIP_WEBINF_LIB, new File(this.tomcat, "lib"), MISSING_WEBINF_LIBS, zout);
            this.zipLibs(ZIP_LIB, new File(this.tomcat, "lib"), MISSING_LIBS, zout);
            this.zipLibs(ZIP_ENDORSED, new File(this.tomcat, "endorsed"), ENDORSED_LIBS, zout);
        }
        finally {
            zout.finish();
            zout.close();
        }
    }

    protected static File newFile(File base, String path) {
        return new File(base, path.replace("/", File.separator));
    }

    protected void zipLibs(String prefix, File dir, List<String> patterns, ZipOutputStream zout) throws IOException {
        block0: for (String name : dir.list()) {
            for (String pat : patterns) {
                if ((!name.startsWith(pat + '-') || !name.endsWith(".jar")) && !name.equals(pat + ".jar")) continue;
                this.zipFile(prefix + name, new File(dir, name), zout, null);
                continue block0;
            }
        }
    }

    protected void zipDirectory(String entryName, ZipOutputStream zout) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        zout.putNextEntry(zentry);
        zout.closeEntry();
    }

    protected void zipFile(String entryName, File file, ZipOutputStream zout, FileProcessor processor) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        if (processor == null) {
            processor = CopyProcessor.INSTANCE;
            zentry.setTime(file.lastModified());
        }
        zout.putNextEntry(zentry);
        processor.process(file, zout);
        zout.closeEntry();
    }

    protected void zipBytes(String entryName, byte[] bytes, ZipOutputStream zout) throws IOException {
        ZipEntry zentry = new ZipEntry(entryName);
        zout.putNextEntry(zentry);
        zout.write(bytes);
        zout.closeEntry();
    }

    protected void zipTree(String prefix, File root, boolean includeRoot, ZipOutputStream zout) throws IOException {
        if (includeRoot) {
            prefix = prefix + root.getName() + '/';
            this.zipDirectory(prefix, zout);
        }
        for (String name : root.list()) {
            File file = new File(root, name);
            if (file.isDirectory()) {
                this.zipTree(prefix, file, true, zout);
                continue;
            }
            if (name.endsWith("~") || name.endsWith("#") || name.endsWith(".bak") || name.equals("README.txt")) continue;
            name = prefix + name;
            WebXmlProcessor processor = name.equals("webapps/nuxeo/WEB-INF/web.xml") ? WebXmlProcessor.INSTANCE : null;
            this.zipFile(name, file, zout, processor);
        }
    }

    public static void fail(String message) {
        PackWar.fail(message, null);
    }

    public static void fail(String message, Throwable t) {
        log.error((Object)message, t);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3 || args.length == 3 && !Arrays.asList(COMMAND_PREPROCESSING, COMMAND_PACKAGING).contains(args[2])) {
            PackWar.fail(String.format("Usage: %s <nxserver_dir> <target_zip> [command]\n    command may be empty or '%s' or '%s'", PackWar.class.getSimpleName(), COMMAND_PREPROCESSING, COMMAND_PACKAGING));
        }
        File nxserver = new File(args[0]).getAbsoluteFile();
        File zip = new File(args[1]).getAbsoluteFile();
        String command = args.length == 3 ? args[2] : null;
        log.info((Object)("Packing nuxeo WAR at " + nxserver + " into " + zip));
        try {
            new PackWar(nxserver, zip).execute(command);
        }
        catch (Exception e) {
            PackWar.fail("Pack failed", e);
        }
    }

    protected static class ServerXmlProcessor
    implements FileProcessor {
        public static ServerXmlProcessor INSTANCE = new ServerXmlProcessor();
        private static final String GLOBAL_NAMING_RESOURCES = "GlobalNamingResources";
        private static final String RESOURCE = "Resource";
        private static final String NAME = "name";
        private static final String JDBC_NUXEO = "jdbc/nuxeo";
        public String resource;

        protected ServerXmlProcessor() {
        }

        @Override
        public void process(File file, OutputStream out) throws IOException {
            DocumentBuilder parser;
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException().initCause(e);
            }
            FileInputStream in = new FileInputStream(file);
            try {
                Document doc = parser.parse(in);
                doc.setStrictErrorChecking(false);
                Element root = doc.getDocumentElement();
                Node n = root.getFirstChild();
                Element resourceElement = null;
                while (n != null) {
                    Node next = n.getNextSibling();
                    String name = n.getNodeName();
                    if (GLOBAL_NAMING_RESOURCES.equals(name)) {
                        next = n.getFirstChild();
                    }
                    if (RESOURCE.equals(name) && ((Element)n).getAttribute(NAME).equals(JDBC_NUXEO)) {
                        resourceElement = (Element)n;
                        break;
                    }
                    n = next;
                }
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.setOutputProperty("omit-xml-declaration", "yes");
                trans.setOutputProperty("indent", "no");
                trans.transform(new DOMSource(resourceElement), new StreamResult(out));
            }
            catch (SAXException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (TransformerException e) {
                throw (IOException)new IOException().initCause(e);
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    protected static class NuxeoXmlProcessor
    extends XmlProcessor {
        public static NuxeoXmlProcessor INSTANCE = new NuxeoXmlProcessor();
        private static final String DOCBASE = "docBase";
        private static final String LOADER = "Loader";
        private static final String LISTENER = "Listener";

        protected NuxeoXmlProcessor() {
        }

        @Override
        protected void process(Document doc) {
            Element root = doc.getDocumentElement();
            root.removeAttribute(DOCBASE);
            Node n = root.getFirstChild();
            while (n != null) {
                Node next = n.getNextSibling();
                String name = n.getNodeName();
                if (LOADER.equals(name) || LISTENER.equals(name)) {
                    root.removeChild(n);
                }
                n = next;
            }
        }
    }

    protected static class WebXmlProcessor
    extends XmlProcessor {
        public static WebXmlProcessor INSTANCE = new WebXmlProcessor();
        private static final String LISTENER = "listener";
        private static final String LISTENER_CLASS = "listener-class";

        protected WebXmlProcessor() {
        }

        @Override
        protected void process(Document doc) {
            for (Node n = doc.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!LISTENER.equals(n.getNodeName())) continue;
                Element listener = doc.createElement(LISTENER);
                n.insertBefore(listener, n);
                listener.appendChild(doc.createElement(LISTENER_CLASS)).appendChild(doc.createTextNode(NuxeoStarter.class.getName()));
                break;
            }
        }
    }

    protected static abstract class XmlProcessor
    implements FileProcessor {
        protected XmlProcessor() {
        }

        @Override
        public void process(File file, OutputStream out) throws IOException {
            DocumentBuilder parser;
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException().initCause(e);
            }
            FileInputStream in = new FileInputStream(file);
            try {
                Document doc = parser.parse(in);
                doc.setStrictErrorChecking(false);
                this.process(doc);
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.setOutputProperty("omit-xml-declaration", "no");
                trans.setOutputProperty("indent", "yes");
                trans.transform(new DOMSource(doc), new StreamResult(out));
            }
            catch (SAXException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (TransformerException e) {
                throw (IOException)new IOException().initCause(e);
            }
            finally {
                ((InputStream)in).close();
            }
        }

        protected abstract void process(Document var1);
    }

    protected static class CopyProcessor
    implements FileProcessor {
        public static CopyProcessor INSTANCE = new CopyProcessor();

        protected CopyProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(File file, OutputStream out) throws IOException {
            FileInputStream in = new FileInputStream(file);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                in.close();
            }
        }
    }

    protected static interface FileProcessor {
        public void process(File var1, OutputStream var2) throws IOException;
    }
}

