/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf;

import com.lowagie.text.ElementTags;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class ITextUtils {
    static Map<String, Color> colorMap = new HashMap<String, Color>();

    public static int alignmentValue(String alignment) {
        return ElementTags.alignmentValue((String)alignment);
    }

    public static Rectangle pageSizeValue(String name) {
        return PageSize.getRectangle((String)name);
    }

    public static Color colorValue(String colorName) {
        if (colorName == null) {
            return null;
        }
        Color color = colorMap.get(colorName = colorName.trim().toLowerCase());
        if (color == null && colorName.startsWith("rgb")) {
            color = ITextUtils.rgbStringToColor(colorName);
        }
        if (color == null) {
            color = Color.decode(colorName);
        }
        return color;
    }

    public static Color rgbStringToColor(String rgbString) {
        String[] rgb = rgbString.split(",");
        if (rgb.length == 3) {
            return new Color(ITextUtils.parseSingleChanel(rgb[0]), ITextUtils.parseSingleChanel(rgb[1]), ITextUtils.parseSingleChanel(rgb[2]));
        }
        if (rgb.length == 4) {
            return new Color(ITextUtils.parseSingleChanel(rgb[0]), ITextUtils.parseSingleChanel(rgb[1]), ITextUtils.parseSingleChanel(rgb[2]), ITextUtils.parseSingleChanel(rgb[3]));
        }
        throw new RuntimeException("invalid rgb color specification: " + rgbString);
    }

    private static int parseSingleChanel(String chanel) {
        if (chanel.contains("%")) {
            float percent = Float.parseFloat(chanel.replaceAll("[^0-9\\.]", ""));
            return (int)(255.0f * (percent / 100.0f));
        }
        return Integer.parseInt(chanel.replaceAll("[^0-9]", ""));
    }

    public static float[] stringToFloatArray(String text) {
        String[] parts = text.split("\\s");
        float[] values = new float[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            values[i] = Float.valueOf(parts[i]).floatValue();
        }
        return values;
    }

    public static int[] stringToIntArray(String text) {
        String[] parts = text.split("\\s");
        int[] values = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            values[i] = Integer.valueOf(parts[i]);
        }
        return values;
    }

    static {
        colorMap.put("white", Color.white);
        colorMap.put("gray", Color.gray);
        colorMap.put("lightgray", Color.lightGray);
        colorMap.put("darkgray", Color.darkGray);
        colorMap.put("black", Color.black);
        colorMap.put("red", Color.red);
        colorMap.put("pink", Color.pink);
        colorMap.put("yellow", Color.yellow);
        colorMap.put("green", Color.green);
        colorMap.put("magenta", Color.magenta);
        colorMap.put("cyan", Color.cyan);
        colorMap.put("blue", Color.blue);
        colorMap.put("orange", Color.orange);
    }
}

