/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.nuxeo.ecm.webengine.jaxrs.Activator;
import org.nuxeo.ecm.webengine.jaxrs.BundleNotFoundException;
import org.osgi.framework.Bundle;

public class Utils {
    public static Class<?>[] loadClasses(String classRefs) throws ClassNotFoundException, BundleNotFoundException {
        return Utils.loadClasses(classRefs, ',');
    }

    public static Class<?>[] loadClasses(String classRefs, char sep) throws ClassNotFoundException, BundleNotFoundException {
        StringBuilder buf = null;
        ArrayList classes = new ArrayList();
        char[] chars = classRefs.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c <= ' ') continue;
            if (c == sep) {
                if (buf == null) continue;
                classes.add(Utils.loadClass(buf.toString()));
                buf = null;
                continue;
            }
            if (buf == null) {
                buf = new StringBuilder();
            }
            buf.append(c);
        }
        if (buf != null) {
            classes.add(Utils.loadClass(buf.toString()));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static <T> T[] newInstances(Class<T> componentType, String classRefs) throws Exception {
        return Utils.newInstances(componentType, classRefs, ',');
    }

    public static <T> T[] newInstances(Class<T> componentType, String classRefs, char sep) throws Exception {
        Class<?>[] classes = Utils.loadClasses(classRefs, sep);
        Object[] ar = (Object[])Array.newInstance(componentType, classes.length);
        for (int i = 0; i < classes.length; ++i) {
            ar[i] = classes[i].newInstance();
        }
        return ar;
    }

    public static Class<?> loadClass(String classRef) throws ClassNotFoundException, BundleNotFoundException {
        int i = classRef.indexOf(58);
        if (i == -1) {
            return Activator.getInstance().getContext().getBundle().loadClass(classRef.trim());
        }
        return Utils.loadClass(classRef.substring(0, i).trim(), classRef.substring(i + 1).trim());
    }

    public static ClassRef getClassRef(String classRef) throws ClassNotFoundException, BundleNotFoundException {
        return Utils.getClassRef(classRef, null);
    }

    public static ClassRef getClassRef(String classRef, Bundle bundle) throws ClassNotFoundException, BundleNotFoundException {
        int i = classRef.indexOf(58);
        if (i == -1) {
            if (bundle == null) {
                bundle = Activator.getInstance().getContext().getBundle();
            }
            return new ClassRef(bundle, bundle.loadClass(classRef.trim()));
        }
        String bundleId = classRef.substring(0, i).trim();
        String className = classRef.substring(i + 1).trim();
        Bundle[] bundles = Activator.getInstance().getPackageAdmin().getBundles(bundleId, null);
        if (bundles != null) {
            return new ClassRef(bundles[0], bundles[0].loadClass(className));
        }
        throw new BundleNotFoundException(bundleId);
    }

    public static Class<?> loadClass(String bundleId, String className) throws ClassNotFoundException, BundleNotFoundException {
        Bundle[] bundles = Activator.getInstance().getPackageAdmin().getBundles(bundleId, null);
        if (bundles != null) {
            return bundles[0].loadClass(className);
        }
        throw new BundleNotFoundException(bundleId);
    }

    public static Object newInstance(String bundleId, String className) throws Exception {
        return Utils.loadClass(bundleId, className).newInstance();
    }

    public static Object newInstance(String classRef) throws Exception {
        return Utils.loadClass(classRef).newInstance();
    }

    public static class ClassRef {
        protected Bundle bundle;
        protected Class<?> clazz;

        public ClassRef(Bundle bundle, Class<?> clazz) {
            this.bundle = bundle;
            this.clazz = clazz;
        }

        public Class<?> get() {
            return this.clazz;
        }

        public Bundle bundle() {
            return this.bundle;
        }

        public Object newInstance() throws Exception {
            return this.clazz.newInstance();
        }

        public String toString() {
            if (this.bundle != null) {
                return this.bundle.getSymbolicName() + ":" + this.clazz.getName();
            }
            return this.clazz.getName();
        }
    }
}

