/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.ObjectTypePair;
import com.google.gson.Preconditions;
import com.google.gson.Primitives;
import com.google.gson.TypeInfo;
import com.google.gson.TypeInfoFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectNavigator {
    private final ExclusionStrategy exclusionStrategy;
    private final ObjectTypePair objTypePair;

    ObjectNavigator(ObjectTypePair objTypePair, ExclusionStrategy exclusionStrategy) {
        Preconditions.checkNotNull(exclusionStrategy);
        this.objTypePair = objTypePair;
        this.exclusionStrategy = exclusionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Visitor visitor) {
        TypeInfo objTypeInfo = new TypeInfo(this.objTypePair.getType());
        if (this.exclusionStrategy.shouldSkipClass(objTypeInfo.getRawClass())) {
            return;
        }
        boolean visitedWithCustomHandler = visitor.visitUsingCustomHandler(this.objTypePair);
        if (!visitedWithCustomHandler) {
            Object objectToVisit;
            Object obj = this.objTypePair.getObject();
            Object object = objectToVisit = obj == null ? visitor.getTarget() : obj;
            if (objectToVisit == null) {
                return;
            }
            this.objTypePair.setObject(objectToVisit);
            visitor.start(this.objTypePair);
            try {
                if (objTypeInfo.isArray()) {
                    visitor.visitArray(objectToVisit, this.objTypePair.getType());
                } else if (objTypeInfo.getActualType() == Object.class && this.isPrimitiveOrString(objectToVisit)) {
                    visitor.visitPrimitive(objectToVisit);
                    objectToVisit = visitor.getTarget();
                } else {
                    Class<?> topLevelClass;
                    visitor.startVisitingObject(objectToVisit);
                    ObjectTypePair currObjTypePair = this.objTypePair.toMoreSpecificType();
                    for (Class<?> curr = topLevelClass = new TypeInfo(currObjTypePair.getType()).getRawClass(); curr != null && !curr.equals(Object.class); curr = curr.getSuperclass()) {
                        if (curr.isSynthetic()) continue;
                        this.navigateClassFields(objectToVisit, curr, visitor);
                    }
                }
            }
            finally {
                visitor.end(this.objTypePair);
            }
        }
    }

    private boolean isPrimitiveOrString(Object objectToVisit) {
        Class<?> realClazz = objectToVisit.getClass();
        return realClazz == Object.class || realClazz == String.class || Primitives.unwrap(realClazz).isPrimitive();
    }

    private void navigateClassFields(Object obj, Class<?> clazz, Visitor visitor) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject f : fields) {
            TypeInfo fieldTypeInfo;
            Type declaredTypeOfField;
            boolean visitedWithCustomHandler;
            FieldAttributes fieldAttributes = new FieldAttributes((Field)f);
            if (this.exclusionStrategy.shouldSkipField(fieldAttributes) || this.exclusionStrategy.shouldSkipClass(fieldAttributes.getDeclaredClass()) || (visitedWithCustomHandler = visitor.visitFieldUsingCustomHandler((Field)f, declaredTypeOfField = (fieldTypeInfo = TypeInfoFactory.getTypeInfoForField((Field)f, this.objTypePair.getType())).getActualType(), obj))) continue;
            if (fieldTypeInfo.isArray()) {
                visitor.visitArrayField((Field)f, declaredTypeOfField, obj);
                continue;
            }
            visitor.visitObjectField((Field)f, declaredTypeOfField, obj);
        }
    }

    public static interface Visitor {
        public void start(ObjectTypePair var1);

        public void end(ObjectTypePair var1);

        public void startVisitingObject(Object var1);

        public void visitArray(Object var1, Type var2);

        public void visitObjectField(Field var1, Type var2, Object var3);

        public void visitArrayField(Field var1, Type var2, Object var3);

        public boolean visitUsingCustomHandler(ObjectTypePair var1);

        public boolean visitFieldUsingCustomHandler(Field var1, Type var2, Object var3);

        public Object getTarget();

        public void visitPrimitive(Object var1);
    }
}

