/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.net.URI;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class NamespacePackageResolver {
    private static final String JAVA_SCHEME = "java";
    private static final LogProvider log = Logging.getLogProvider(NamespacePackageResolver.class);

    public String resolve(String ns) {
        try {
            return this.parseURI(new URI(ns));
        }
        catch (Exception e) {
            return null;
        }
    }

    private String parseURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException(uri + " is not an absolute URI");
        }
        return uri.isOpaque() ? this.parseOpaqueURI(uri) : this.parseHierarchicalURI(uri);
    }

    private String parseOpaqueURI(URI uri) {
        if (uri.getScheme().equalsIgnoreCase(JAVA_SCHEME)) {
            return uri.getSchemeSpecificPart();
        }
        throw new IllegalArgumentException("Unrecognized scheme in " + uri);
    }

    private String parseHierarchicalURI(URI uri) {
        String scheme = uri.getScheme().toLowerCase();
        if (!scheme.equals("http") && !scheme.equals("https")) {
            throw new IllegalArgumentException("Hierarchical URLs must use http or https scheme " + uri);
        }
        StringBuffer buf = new StringBuffer();
        this.appendToPackageName(buf, this.hostnameToPackage(uri.getHost()));
        this.appendToPackageName(buf, this.pathToPackage(uri.getPath()));
        return buf.toString();
    }

    private String pathToPackage(String path) {
        StringBuffer buf = new StringBuffer();
        if (path != null) {
            String[] pathElements = path.split("/");
            int len = pathElements.length;
            for (int i = 1; i < len; ++i) {
                this.appendToPackageName(buf, pathElements[i]);
            }
        }
        return buf.toString();
    }

    private String hostnameToPackage(String hostname) {
        StringBuffer result = new StringBuffer();
        String[] subdomains = hostname.split("\\.");
        for (int i = subdomains.length - 1; i >= 0; --i) {
            String subdomain = subdomains[i];
            if (i <= 0 && subdomain.equalsIgnoreCase("www")) continue;
            this.appendToPackageName(result, subdomain);
        }
        return result.toString();
    }

    private void appendToPackageName(StringBuffer buf, String subdomain) {
        if (subdomain.length() > 0) {
            subdomain = this.makeSafeForJava(subdomain);
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(subdomain);
        }
    }

    private String makeSafeForJava(String subdomain) {
        return subdomain.replace("-", "_");
    }
}

