/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.StaleStateException;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.db.JobSession;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;

public class ExecuteJobsCommand
implements Command {
    private static final long serialVersionUID = -2457066688404533959L;
    private static final Log log = LogFactory.getLog(ExecuteJobsCommand.class);
    private static final int maxLockTime = 60000;
    private transient JbpmContext jbpmContext;

    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.jbpmContext = jbpmContext;
        try {
            Collection acquiredJobs = this.acquireJobs();
            if (!acquiredJobs.isEmpty()) {
                for (Job job : acquiredJobs) {
                    this.executeJob(job);
                }
            }
        }
        catch (JbpmException ex) {
            log.warn((Object)"exception while executing job", (Throwable)ex);
        }
        this.jbpmContext = null;
        return null;
    }

    private String getName() {
        return this.toString();
    }

    protected Collection acquireJobs() {
        ArrayList<Job> acquiredJobs = null;
        ArrayList<Job> jobsToLock = new ArrayList<Job>();
        log.debug((Object)"acquiring jobs for execution...");
        try {
            JobSession jobSession = this.jbpmContext.getJobSession();
            log.debug((Object)"querying for acquirable job...");
            Job job2 = jobSession.getFirstAcquirableJob(this.getName());
            if (job2 != null) {
                if (job2.isExclusive()) {
                    log.debug((Object)("exclusive acquirable job found (" + job2 + "). querying for other exclusive jobs to lock them all in one tx..."));
                    List otherExclusiveJobs = jobSession.findExclusiveJobs(this.getName(), job2.getProcessInstance());
                    jobsToLock.addAll(otherExclusiveJobs);
                    log.debug((Object)("trying to obtain a process-instance exclusive locks for '" + otherExclusiveJobs + "'"));
                } else {
                    log.debug((Object)("trying to obtain a lock for '" + job2 + "'"));
                    jobsToLock.add(job2);
                }
                for (Job job2 : jobsToLock) {
                    job2.setLockOwner(this.getName());
                    job2.setLockTime(new Date());
                }
                if (job2 instanceof Timer) {
                    Hibernate.initialize((Object)((Timer)job2).getGraphElement());
                }
            } else {
                log.debug((Object)"no acquirable jobs in job table");
            }
            acquiredJobs = jobsToLock;
            log.debug((Object)("obtained locks on following jobs: " + acquiredJobs));
        }
        catch (StaleStateException e) {
            log.debug((Object)("couldn't acquire lock on job(s): " + jobsToLock));
        }
        return acquiredJobs;
    }

    protected void executeJob(Job job) {
        JobSession jobSession = this.jbpmContext.getJobSession();
        job = jobSession.loadJob(job.getId());
        try {
            log.debug((Object)("executing job " + job));
            if (job.execute(this.jbpmContext)) {
                jobSession.deleteJob(job);
            }
        }
        catch (Exception e) {
            log.debug((Object)("exception while executing '" + job + "'"), (Throwable)e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            job.setException(sw.toString());
            job.setRetries(job.getRetries() - 1);
        }
        long totalLockTimeInMillis = System.currentTimeMillis() - job.getLockTime().getTime();
        if (totalLockTimeInMillis > 60000L) {
            this.jbpmContext.setRollbackOnly();
        }
    }

    protected Date getNextDueDate() {
        Date nextDueDate = null;
        JobSession jobSession = this.jbpmContext.getJobSession();
        Job job = jobSession.getFirstDueJob(this.getName(), new ArrayList());
        if (job != null) {
            nextDueDate = job.getDueDate();
        }
        return nextDueDate;
    }
}

