/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.serializer;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.syndication.serializer.AbstractSyndicationSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.DashBoardItemSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;
import org.nuxeo.ecm.platform.syndication.workflow.DashBoardItem;
import org.nuxeo.ecm.platform.syndication.workflow.TaskModuleImpl;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Response;

public class ATOMSerializer
extends AbstractSyndicationSerializer
implements DashBoardItemSerializer {
    private static final String ATOM_TYPE_old = "atom_0.3";
    private static final String ATOM_TYPE = "atom_1.0";

    @Override
    public String serialize(ResultSummary summary, DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req) {
        this.setSyndicationFormat(ATOM_TYPE);
        return super.serialize(summary, docList, columnsDefinition, req);
    }

    @Override
    public void serialize(ResultSummary summary, List<DashBoardItem> workItems, String columnsDefinition, List<String> labels, String lang, Response response, HttpServletRequest req) throws ClientException {
        SyndFeedImpl atomFeed = new SyndFeedImpl();
        atomFeed.setFeedType(ATOM_TYPE);
        atomFeed.setTitle(summary.getTitle());
        atomFeed.setLink(summary.getLink());
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        for (DashBoardItem item : workItems) {
            entries.add(ATOMSerializer.adaptDashBoardItem(item, req));
        }
        atomFeed.setEntries(entries);
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            response.setEntity(output.outputString((SyndFeed)atomFeed), MediaType.TEXT_XML);
            response.getEntity().setCharacterSet(CharacterSet.UTF_8);
        }
        catch (FeedException fe) {
            // empty catch block
        }
    }

    private static SyndEntry adaptDashBoardItem(DashBoardItem item, HttpServletRequest req) throws ClientException {
        SyndEntryImpl entry = new SyndEntryImpl();
        TaskModuleImpl taskModule = new TaskModuleImpl();
        taskModule.setDirective(item.getDirective());
        taskModule.setDueDate(item.getDueDate());
        taskModule.setStartDate(item.getStartDate());
        taskModule.setDescription(item.getDescription());
        taskModule.setName(item.getName());
        taskModule.setComment(item.getComment());
        ArrayList<TaskModuleImpl> modules = new ArrayList<TaskModuleImpl>();
        modules.add(taskModule);
        entry.setModules(modules);
        String docTitle = (String)item.getDocument().getProperty("dublincore", "title");
        entry.setTitle(docTitle);
        entry.setLink(DocumentModelFunctions.documentUrl(null, (DocumentModel)item.getDocument(), null, null, (boolean)true, (HttpServletRequest)req));
        return entry;
    }
}

