/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutConverterDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class LayoutConverterRegistry
extends ContributionFragmentRegistry<LayoutConverterDescriptor> {
    protected final String category;
    protected final Map<String, LayoutConverterDescriptor> converters;

    public LayoutConverterRegistry(String category) {
        this.category = category;
        this.converters = new HashMap<String, LayoutConverterDescriptor>();
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getLayoutNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.converters.keySet());
        return res;
    }

    public String getContributionId(LayoutConverterDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, LayoutConverterDescriptor contrib, LayoutConverterDescriptor newOrigContrib) {
        this.converters.put(id, contrib);
    }

    public void contributionRemoved(String id, LayoutConverterDescriptor origContrib) {
        this.converters.remove(id);
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public LayoutConverterDescriptor clone(LayoutConverterDescriptor orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(LayoutConverterDescriptor src, LayoutConverterDescriptor dst) {
        throw new UnsupportedOperationException();
    }

    public List<LayoutConverterDescriptor> getConverters() {
        ArrayList<LayoutConverterDescriptor> res = new ArrayList<LayoutConverterDescriptor>();
        for (LayoutConverterDescriptor item : this.converters.values()) {
            if (item == null) continue;
            res.add(item);
        }
        return res;
    }

    public LayoutConverterDescriptor getConverter(String id) {
        return this.converters.get(id);
    }
}

