/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.RenderingInfo;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetSelectOption;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.descriptors.FieldDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.PropertiesDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.RenderingInfoDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.RenderingInfosDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetSelectOptionDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetSelectOptionsDescriptor;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XObject(value="widget")
public class WidgetDescriptor {
    private static final Log log = LogFactory.getLog(WidgetDescriptor.class);
    @XNode(value="@name")
    String name;
    @XNode(value="@type")
    String type;
    @XNodeList(value="fields/field", type=FieldDescriptor[].class, componentType=FieldDescriptor.class)
    FieldDescriptor[] fields = new FieldDescriptor[0];
    @XNodeMap(value="widgetModes/mode", key="@value", type=HashMap.class, componentType=String.class)
    Map<String, String> modes = new HashMap<String, String>();
    @XNodeMap(value="labels/label", key="@mode", type=HashMap.class, componentType=String.class)
    Map<String, String> labels = new HashMap<String, String>();
    @XNodeMap(value="helpLabels/label", key="@mode", type=HashMap.class, componentType=String.class)
    Map<String, String> helpLabels = new HashMap<String, String>();
    @XNode(value="translated")
    boolean translated = true;
    @XNodeMap(value="properties", key="@mode", type=HashMap.class, componentType=PropertiesDescriptor.class)
    Map<String, PropertiesDescriptor> properties = new HashMap<String, PropertiesDescriptor>();
    @XNodeMap(value="properties", key="@widgetMode", type=HashMap.class, componentType=PropertiesDescriptor.class)
    Map<String, PropertiesDescriptor> widgetModeProperties = new HashMap<String, PropertiesDescriptor>();
    @XNodeList(value="subWidgets/widget", type=WidgetDescriptor[].class, componentType=WidgetDescriptor.class)
    WidgetDescriptor[] subWidgets = new WidgetDescriptor[0];
    WidgetSelectOption[] selectOptions = new WidgetSelectOption[0];
    @XNodeMap(value="renderingInfos", key="@mode", type=HashMap.class, componentType=RenderingInfosDescriptor.class)
    Map<String, RenderingInfosDescriptor> renderingInfos = new HashMap<String, RenderingInfosDescriptor>();
    @XNodeList(value="categories/category", type=String[].class, componentType=String.class)
    String[] categories = new String[0];

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public FieldDefinition[] getFieldDefinitions() {
        if (this.fields == null) {
            return null;
        }
        FieldDefinition[] res = new FieldDefinition[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            res[i] = this.fields[i].getFieldDefinition();
        }
        return res;
    }

    public String getMode(String layoutMode) {
        String mode = this.modes.get(layoutMode);
        if (mode == null) {
            mode = this.modes.get("any");
        }
        return mode;
    }

    public Map<String, String> getModes() {
        return this.modes;
    }

    public String getRequired(String layoutMode, String mode) {
        String res = "false";
        Map<String, Serializable> props = this.getProperties(layoutMode, mode);
        if (props != null && props.containsKey("required")) {
            Serializable value = props.get("required");
            if (value instanceof String) {
                res = (String)((Object)value);
            } else {
                log.error((Object)String.format("Invalid property \"%s\" on widget %s: %s", "required", value, this.name));
            }
        }
        return res;
    }

    public String getLabel(String mode) {
        String label = this.labels.get(mode);
        if (label == null) {
            label = this.labels.get("any");
        }
        return label;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getHelpLabel(String mode) {
        String label = this.helpLabels.get(mode);
        if (label == null) {
            label = this.helpLabels.get("any");
        }
        return label;
    }

    public Map<String, String> getHelpLabels() {
        return this.helpLabels;
    }

    public boolean isTranslated() {
        return this.translated;
    }

    public Map<String, Serializable> getProperties(String layoutMode, String mode) {
        Map<String, Serializable> modeProps = WidgetDescriptor.getProperties(this.properties, layoutMode);
        Map<String, Serializable> widgetModeProps = WidgetDescriptor.getProperties(this.widgetModeProperties, mode);
        if (modeProps == null && widgetModeProps == null) {
            return null;
        }
        if (widgetModeProps == null) {
            return modeProps;
        }
        if (modeProps == null) {
            return widgetModeProps;
        }
        HashMap<String, Serializable> res = new HashMap<String, Serializable>(modeProps);
        res.putAll(widgetModeProps);
        return res;
    }

    public Map<String, Map<String, Serializable>> getProperties() {
        return WidgetDescriptor.getProperties(this.properties);
    }

    public Map<String, Map<String, Serializable>> getWidgetModeProperties() {
        return WidgetDescriptor.getProperties(this.widgetModeProperties);
    }

    public WidgetDefinition[] getSubWidgetDefinitions() {
        WidgetDefinition[] csubWidgets = null;
        if (this.subWidgets != null) {
            csubWidgets = new WidgetDefinition[this.subWidgets.length];
            for (int i = 0; i < this.subWidgets.length; ++i) {
                csubWidgets[i] = this.subWidgets[i].getWidgetDefinition();
            }
        }
        return csubWidgets;
    }

    public static Map<String, Serializable> getProperties(Map<String, PropertiesDescriptor> map, String mode) {
        if (map == null) {
            return null;
        }
        PropertiesDescriptor defaultProps = map.get("any");
        PropertiesDescriptor props = map.get(mode);
        if (defaultProps == null && props == null) {
            return null;
        }
        if (defaultProps == null) {
            return props.getProperties();
        }
        if (props == null) {
            return defaultProps.getProperties();
        }
        HashMap<String, Serializable> res = new HashMap<String, Serializable>(defaultProps.getProperties());
        res.putAll(props.getProperties());
        return res;
    }

    public static Map<String, Map<String, Serializable>> getProperties(Map<String, PropertiesDescriptor> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, Map<String, Serializable>> res = new HashMap<String, Map<String, Serializable>>();
        for (Map.Entry<String, PropertiesDescriptor> item : map.entrySet()) {
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.putAll(item.getValue().getProperties());
            res.put(item.getKey(), props);
        }
        return res;
    }

    public WidgetSelectOption[] getSelectOptions() {
        return this.selectOptions;
    }

    @XContent(value="selectOptions")
    public void setSelectOptions(DocumentFragment selectOptionsDOM) {
        XMap xmap = new XMap();
        xmap.register(WidgetSelectOptionDescriptor.class);
        xmap.register(WidgetSelectOptionsDescriptor.class);
        ArrayList<WidgetSelectOption> options = new ArrayList<WidgetSelectOption>();
        for (Node p = selectOptionsDOM.getFirstChild(); p != null; p = p.getNextSibling()) {
            if (p.getNodeType() != 1) continue;
            try {
                Object desc = xmap.load((Element)p);
                if (desc instanceof WidgetSelectOptionDescriptor) {
                    options.add(((WidgetSelectOptionDescriptor)desc).getWidgetSelectOption());
                    continue;
                }
                if (desc instanceof WidgetSelectOptionsDescriptor) {
                    options.add(((WidgetSelectOptionsDescriptor)desc).getWidgetSelectOption());
                    continue;
                }
                log.error((Object)"Unknown resolution of select option");
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        this.selectOptions = options.toArray(new WidgetSelectOption[0]);
    }

    public String[] getCategories() {
        return this.categories;
    }

    public WidgetDefinition getWidgetDefinition() {
        HashMap<String, String> clabels = null;
        if (this.labels != null) {
            clabels = new HashMap<String, String>();
            clabels.putAll(this.labels);
        }
        HashMap<String, String> chelpLabels = null;
        if (this.helpLabels != null) {
            chelpLabels = new HashMap<String, String>();
            chelpLabels.putAll(this.helpLabels);
        }
        HashMap<String, String> cmodes = null;
        if (this.modes != null) {
            cmodes = new HashMap<String, String>();
            cmodes.putAll(this.modes);
        }
        FieldDefinition[] cfieldDefinitions = this.getFieldDefinitions();
        WidgetDefinition[] csubWidgets = this.getSubWidgetDefinitions();
        WidgetSelectOption[] cselectOptions = null;
        if (this.selectOptions != null) {
            cselectOptions = new WidgetSelectOption[this.selectOptions.length];
            for (int i = 0; i < this.selectOptions.length; ++i) {
                cselectOptions[i] = this.selectOptions[i].clone();
            }
        }
        HashMap crenderingInfos = null;
        if (this.renderingInfos != null) {
            crenderingInfos = new HashMap();
            for (Map.Entry<String, RenderingInfosDescriptor> item : this.renderingInfos.entrySet()) {
                RenderingInfosDescriptor infos = item.getValue();
                ArrayList<RenderingInfo> clonedInfos = null;
                if (infos != null) {
                    clonedInfos = new ArrayList<RenderingInfo>();
                    for (RenderingInfoDescriptor info : infos.getRenderingInfos()) {
                        clonedInfos.add(info.getRenderingInfo());
                    }
                }
                crenderingInfos.put(item.getKey(), clonedInfos);
            }
        }
        WidgetDefinitionImpl clone = new WidgetDefinitionImpl(this.name, this.type, clabels, chelpLabels, this.translated, cmodes, cfieldDefinitions, this.getProperties(), this.getWidgetModeProperties(), csubWidgets, cselectOptions);
        clone.setRenderingInfos(crenderingInfos);
        return clone;
    }
}

