/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.CoreSessionFactory;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.api.Framework;

public class CoreInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CoreInstance.class);
    private static final CoreInstance instance = new CoreInstance();
    private CoreSessionFactory factory;
    private final Map<String, RegistrationInfo> sessions = new ConcurrentHashMap<String, RegistrationInfo>();

    protected CoreInstance() {
    }

    public static CoreInstance getInstance() {
        return instance;
    }

    public CoreSession open(String repositoryName, Map<String, Serializable> context) throws ClientException {
        try {
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            CoreSession session = null;
            if (rm != null) {
                Repository repo = rm.getRepository(repositoryName);
                if (repo == null) {
                    throw new ClientException("No such repository: " + repositoryName);
                }
                session = repo.open(context);
            }
            if (session == null) {
                session = this.compatOpen(repositoryName, context);
            }
            return session;
        }
        catch (Exception e) {
            throw new ClientException("Failed to intialize core session on repository " + repositoryName, e);
        }
    }

    @Deprecated
    private CoreSession compatOpen(String repositoryName, Map<String, Serializable> context) throws ClientException {
        CoreSession client = this.factory.getSession();
        client.connect(repositoryName, context);
        this.registerSession(client.getSessionId(), client);
        return client;
    }

    public void registerSession(String sid, CoreSession session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Register session with id '" + sid + "'."));
        }
        this.sessions.put(sid, new RegistrationInfo(session));
    }

    public CoreSession unregisterSession(String sid) {
        RegistrationInfo info;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregister session with id '" + sid + "'."));
        }
        if ((info = this.sessions.remove(sid)) == null) {
            return null;
        }
        return info.session;
    }

    public void close(CoreSession client) {
        String sid = client.getSessionId();
        if (sid == null) {
            return;
        }
        client = this.unregisterSession(sid);
        if (client != null) {
            client.destroy();
        } else {
            log.warn((Object)"Trying to close a non referenced CoreSession (destroy method won't be called)");
        }
    }

    public boolean isSessionStarted(String sid) {
        return this.sessions.containsKey(sid);
    }

    public int getNumberOfSessions() {
        return this.sessions.size();
    }

    public CoreSession[] getSessions() {
        Collection<RegistrationInfo> infos = this.sessions.values();
        CoreSession[] ret = new CoreSession[infos.size()];
        Iterator<RegistrationInfo> it = infos.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = it.next().session;
        }
        return ret;
    }

    public Collection<RegistrationInfo> getRegistrationInfos() {
        return this.sessions.values();
    }

    public CoreSession getSession(String sid) {
        HashMap<String, CoreSession> reentrantSession = DocumentModelImpl.reentrantCoreSession.get();
        if (reentrantSession != null && reentrantSession.containsKey(sid)) {
            return reentrantSession.get(sid);
        }
        return this.sessions.get((Object)sid).session;
    }

    public RegistrationInfo getSessionRegistrationInfo(String sid) {
        return this.sessions.get(sid);
    }

    public void initialize(CoreSessionFactory factory) {
        CoreInstance.instance.factory = factory;
    }

    public CoreSessionFactory getFactory() {
        return this.factory;
    }

    public static class RegistrationInfo
    extends Throwable {
        private static final long serialVersionUID = 1L;
        public final CoreSession session;
        public final String threadName;

        RegistrationInfo(CoreSession session) {
            super("Session registration context (" + session.getSessionId() + "," + Thread.currentThread().getName() + ")");
            this.session = session;
            this.threadName = Thread.currentThread().getName();
        }
    }
}

