/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SerializableInputStream
extends InputStream
implements Serializable {
    public static final int IN_MEM_LIMIT = 65536;
    private static final long serialVersionUID = -2816387281878881614L;
    private transient File file;
    private transient InputStream in;

    public SerializableInputStream(InputStream in) {
        this.in = in;
    }

    public SerializableInputStream(byte[] content) {
        this.in = new ByteArrayInputStream(content);
    }

    public SerializableInputStream(String content) {
        this(content.getBytes());
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public File getTempFile() {
        return this.file;
    }

    public InputStream reopen() throws IOException {
        if (!this.canReopen()) {
            throw new IOException("Cannot reopen non persistent stream");
        }
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public boolean canReopen() {
        return this.file != null && this.file.isFile();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.file = File.createTempFile("SerializableIS-", ".tmp");
        this.file.deleteOnExit();
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(this.file);
            byte[] buffer = new byte[65536];
            int bytes = in.readInt();
            while (bytes > -1 && (read = in.read(buffer, 0, bytes)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
                if ((bytes -= read) != 0) continue;
                bytes = in.readInt();
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
            if (this.file.isFile()) {
                this.in = new BufferedInputStream(new FileInputStream(this.file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.in == null) {
            return;
        }
        try {
            int read;
            byte[] buf = new byte[65536];
            while ((read = this.in.read(buf)) != -1) {
                out.writeInt(read);
                out.write(buf, 0, read);
            }
            out.writeInt(-1);
        }
        finally {
            if (this.in != null) {
                this.in.close();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.file != null) {
            this.file.delete();
        }
        super.finalize();
    }
}

