/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.converter;

import java.util.Hashtable;
import java.util.Map;
import org.nuxeo.ecm.core.api.impl.converter.BlobConverter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.runtime.api.Framework;

public abstract class ValueConverter {
    private static final SchemaManager typeManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
    private static final Map<String, ValueConverter> converters = new Hashtable<String, ValueConverter>();

    public abstract Object convert(Object var1) throws TypeException;

    public static void addConvertor(String type, ValueConverter convertor) {
        converters.put(type, convertor);
    }

    public static void removeConvertor(String type) {
        converters.remove(type);
    }

    public static Object getValue(String type, Object value) throws TypeException {
        ValueConverter conv = converters.get(type);
        if (conv != null) {
            return conv.convert(value);
        }
        Type theType = typeManager.getType(type);
        if (theType == null) {
            throw new TypeException("No Such Type: " + type);
        }
        return theType.convert(value);
    }

    static {
        converters.put("content", BlobConverter.INSTANCE);
    }
}

