/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common;

import java.util.regex.Pattern;

public class UserAgentMatcher {
    private static final Pattern UA_FIREFOX_3 = Pattern.compile("^[Mm]ozilla.*[Ff]irefox(/|\\s)?(3\\.[6789].*)");
    private static final Pattern UA_FIREFOX_FROM_4 = Pattern.compile("^[Mm]ozilla.*[Ff]irefox(/|\\s)?(([456789].*)|(1[0123456789].*))");
    private static final Pattern UA_SAFARI_5 = Pattern.compile("^Mozilla.*AppleWebKit.*Version/5.*");
    private static final Pattern UA_CHROME = Pattern.compile("^Mozilla.*AppleWebKit.*Chrom(e|ium)/(1[0123456789]).*");
    private static final Pattern UA_MSIE_67 = Pattern.compile("^Mozilla/4.0 \\(compatible; MSIE [67].[0-9].*");

    private UserAgentMatcher() {
    }

    public static boolean isFirefox3(String UA) {
        return UA_FIREFOX_3.matcher(UA).matches();
    }

    public static boolean isFirefox4OrMore(String UA) {
        return UA_FIREFOX_FROM_4.matcher(UA).matches();
    }

    public static boolean isSafari5(String UA) {
        return UA_SAFARI_5.matcher(UA).matches();
    }

    public static boolean isChrome(String UA) {
        return UA_CHROME.matcher(UA).matches();
    }

    public static boolean html5DndIsSupported(String UA) {
        return UserAgentMatcher.isFirefox3(UA) || UserAgentMatcher.isFirefox4OrMore(UA) || UserAgentMatcher.isSafari5(UA) || UserAgentMatcher.isChrome(UA);
    }

    public static boolean isMSIE6or7(String UA) {
        return UA_MSIE_67.matcher(UA).matches();
    }
}

