/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.Action;

public class ActionRegistry
implements Serializable {
    private static final Log log = LogFactory.getLog(ActionRegistry.class);
    private static final long serialVersionUID = 8425627293154848041L;
    private final Map<String, Action> actions = new HashMap<String, Action>();
    private final Map<String, List<String>> categories = new HashMap<String, List<String>>();

    public synchronized void addAction(Action action) {
        String id = action.getId();
        if (log.isDebugEnabled()) {
            if (this.actions.containsKey(id)) {
                log.debug((Object)("Overriding action: " + action));
            } else {
                log.debug((Object)("Registering action: " + action));
            }
        }
        if (action.getLabel() == null) {
            action.setLabel(action.getId());
        }
        this.actions.put(id, action);
        for (String category : action.getCategories()) {
            List<String> acts = this.categories.get(category);
            if (acts == null) {
                acts = new ArrayList<String>();
            }
            if (!acts.contains(id)) {
                acts.add(id);
            }
            this.categories.put(category, acts);
        }
    }

    public synchronized Action removeAction(String id) {
        Action action;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering action: " + id));
        }
        if ((action = this.actions.remove(id)) != null) {
            for (String category : action.getCategories()) {
                List<String> acts = this.categories.get(category);
                if (acts == null) continue;
                acts.remove(id);
            }
        }
        return action;
    }

    public synchronized Collection<Action> getActions() {
        return Collections.unmodifiableCollection(ActionRegistry.sortActions(this.actions.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> getActions(String category) {
        Collection ids;
        List<Action> result = new LinkedList<Action>();
        ActionRegistry actionRegistry = this;
        synchronized (actionRegistry) {
            ids = this.categories.get(category);
        }
        if (ids != null) {
            for (String id : ids) {
                Action action = this.actions.get(id);
                if (action == null || !action.isEnabled()) continue;
                result.add(this.getClonedAction(action));
            }
        }
        result = ActionRegistry.sortActions(result);
        return result;
    }

    public synchronized Action getAction(String id) {
        Action action = this.actions.get(id);
        return this.getClonedAction(action);
    }

    protected Action getClonedAction(Action action) {
        if (action == null) {
            return null;
        }
        try {
            return action.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    protected static List<Action> sortActions(Collection<Action> actions) {
        ArrayList<Action> sortedActions = new ArrayList<Action>();
        if (actions != null) {
            sortedActions.addAll(actions);
            Collections.sort(sortedActions);
        }
        return sortedActions;
    }
}

