/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.service;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskProvider;
import org.nuxeo.ecm.platform.task.TaskQueryConstant;
import org.nuxeo.ecm.platform.task.core.helpers.TaskActorsHelper;

public class DocumentTaskProvider
implements TaskProvider {
    private static final long serialVersionUID = 1L;

    public List<Task> getCurrentTaskInstances(CoreSession coreSession) throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)coreSession.getPrincipal();
        List<String> actors = TaskActorsHelper.getTaskActors(principal);
        return this.getCurrentTaskInstances(actors, coreSession);
    }

    public List<Task> getCurrentTaskInstances(List<String> actors, CoreSession coreSession) throws ClientException {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        String userNames = TaskQueryConstant.formatStringList(actors);
        String query = String.format("SELECT * FROM TaskDoc WHERE (ecm:currentLifeCycleState != 'ended' AND ecm:currentLifeCycleState != 'cancelled')  AND nt:actors IN (%s) ", userNames);
        DocumentModelList taskDocuments = coreSession.query(query);
        return DocumentTaskProvider.wrapDocModelInTask(taskDocuments);
    }

    public List<Task> getTaskInstances(DocumentModel dm, NuxeoPrincipal user, CoreSession coreSession) throws ClientException {
        String query;
        if (user == null) {
            query = String.format("SELECT * FROM TaskDoc WHERE (ecm:currentLifeCycleState != 'ended' AND ecm:currentLifeCycleState != 'cancelled')  AND nt:targetDocumentId = '%s'", dm.getId());
        } else {
            List<String> actors = TaskActorsHelper.getTaskActors(user);
            String userNames = TaskQueryConstant.formatStringList(actors);
            query = String.format("SELECT * FROM TaskDoc WHERE (ecm:currentLifeCycleState != 'ended' AND ecm:currentLifeCycleState != 'cancelled')  AND nt:targetDocumentId = '%s' AND nt:actors IN (%s) ", dm.getId(), userNames);
        }
        DocumentModelList taskDocuments = coreSession.query(query);
        return DocumentTaskProvider.wrapDocModelInTask(taskDocuments);
    }

    public List<Task> getTaskInstances(DocumentModel dm, List<String> actors, CoreSession coreSession) throws ClientException {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        String userNames = TaskQueryConstant.formatStringList(actors);
        String query = String.format("SELECT * FROM TaskDoc WHERE (ecm:currentLifeCycleState != 'ended' AND ecm:currentLifeCycleState != 'cancelled')  AND nt:targetDocumentId = '%s' AND nt:actors IN (%s) ", dm.getId(), userNames);
        DocumentModelList taskDocuments = coreSession.query(query);
        return DocumentTaskProvider.wrapDocModelInTask(taskDocuments);
    }

    public static List<Task> wrapDocModelInTask(DocumentModelList taskDocuments) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (DocumentModel doc : taskDocuments) {
            tasks.add((Task)doc.getAdapter(Task.class));
        }
        return tasks;
    }
}

