/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskPersisterDescriptor;
import org.nuxeo.ecm.platform.task.TaskProvider;
import org.nuxeo.ecm.platform.task.TaskProviderDescriptor;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.service.CreateTaskUnrestricted;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class TaskServiceImpl
extends DefaultComponent
implements TaskService {
    private static final long serialVersionUID = 1L;
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.task.core.TaskService");
    private static final Log log = LogFactory.getLog(TaskServiceImpl.class);
    private static final String TASK_PROVIDER_XP = "taskProvider";
    private static final String TASK_PERSISTER_XP = "taskPersister";
    private EventProducer eventProducer;
    private Map<String, TaskProvider> tasksProviders;
    private String parentPath = "/task-root";

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.tasksProviders = new HashMap<String, TaskProvider>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        this.tasksProviders = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(TASK_PROVIDER_XP)) {
            if (contribution instanceof TaskProviderDescriptor) {
                TaskProviderDescriptor taskProviderDescriptor = (TaskProviderDescriptor)contribution;
                String providerId = taskProviderDescriptor.getId();
                if (taskProviderDescriptor.isEnabled().booleanValue()) {
                    this.tasksProviders.put(providerId, taskProviderDescriptor.getNewInstance());
                } else if (this.tasksProviders.get(providerId) != null) {
                    this.tasksProviders.remove(providerId);
                }
            }
        } else if (extensionPoint.equals(TASK_PERSISTER_XP) && contribution instanceof TaskPersisterDescriptor) {
            TaskPersisterDescriptor taskPersisterDescriptor = (TaskPersisterDescriptor)contribution;
            this.parentPath = taskPersisterDescriptor.getPath();
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        TaskProviderDescriptor taskProviderDescriptor;
        String providerId;
        if (extensionPoint.equals(TASK_PROVIDER_XP) && contribution instanceof TaskProviderDescriptor && this.tasksProviders.get(providerId = (taskProviderDescriptor = (TaskProviderDescriptor)contribution).getId()) != null) {
            this.tasksProviders.remove(providerId);
        }
    }

    public List<Task> createTask(CoreSession coreSession, NuxeoPrincipal principal, DocumentModel document, String taskName, List<String> actorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) throws ClientException {
        if (StringUtils.isBlank((String)parentPath)) {
            parentPath = this.getTaskRootParentPath(coreSession);
        }
        CreateTaskUnrestricted runner = new CreateTaskUnrestricted(coreSession, principal, document, taskName, actorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath);
        runner.runUnrestricted();
        List<Task> tasks = runner.getTasks();
        for (Task task : tasks) {
            HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
            ArrayList<String> notificationRecipients = new ArrayList<String>();
            notificationRecipients.addAll(actorIds);
            if (principal != null && !notificationRecipients.contains("user:" + principal.getName())) {
                notificationRecipients.add("user:" + principal.getName());
            }
            eventProperties.put("recipients", (Serializable)notificationRecipients.toArray(new String[notificationRecipients.size()]));
            this.notifyEvent(coreSession, document, principal, task, "workflowTaskAssigned", eventProperties, comment, null);
        }
        return tasks;
    }

    public void acceptTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment) throws ClientException {
        this.endTask(coreSession, principal, task, comment, "workflowTaskCompleted", true);
    }

    public void rejectTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment) throws ClientException {
        this.endTask(coreSession, principal, task, comment, "workflowTaskRejected", false);
    }

    public void endTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment, String eventName, boolean isValidated) throws ClientException {
        if (!this.canEndTask(principal, task)) {
            throw new ClientException(String.format("User with id '%s' cannot end this task", principal.getName()));
        }
        try {
            if (!StringUtils.isEmpty((String)comment)) {
                task.addComment(principal.getName(), comment);
            }
            task.setVariable(TaskService.VariableName.validated.name(), String.valueOf(isValidated));
            task.end(coreSession);
            coreSession.saveDocument(task.getDocument());
            HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
            ArrayList<String> notificationRecipients = new ArrayList<String>();
            notificationRecipients.add(task.getInitiator());
            notificationRecipients.addAll(task.getActors());
            eventProperties.put("recipients", notificationRecipients);
            DocumentModel document = null;
            String docId = task.getVariable(TaskService.VariableName.documentId.name());
            String docRepo = task.getVariable(TaskService.VariableName.documentRepositoryName.name());
            if (coreSession.getRepositoryName().equals(docRepo)) {
                try {
                    document = coreSession.getDocument((DocumentRef)new IdRef(docId));
                }
                catch (Exception e) {
                    log.error((Object)String.format("Could not fetch document with id '%s:%s' for notification", docRepo, docId), (Throwable)e);
                }
            } else {
                log.error((Object)String.format("Could not resolve document for notification: document is on repository '%s' and given session is on repository '%s'", docRepo, coreSession.getRepositoryName()));
            }
            this.notifyEvent(coreSession, document, principal, task, eventName, eventProperties, comment, null);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public boolean canEndTask(NuxeoPrincipal principal, Task task) throws ClientException {
        if (task != null && !task.isCancelled().booleanValue() && !task.hasEnded().booleanValue()) {
            return principal.isAdministrator() || principal.getName().equals(task.getInitiator()) || this.isTaskAssignedToUser(task, principal);
        }
        return false;
    }

    protected boolean isTaskAssignedToUser(Task task, NuxeoPrincipal user) throws ClientException {
        if (task != null && user != null) {
            List actors = user.getAllGroups();
            actors.add(user.getName());
            if (actors.contains(task.getInitiator())) {
                return true;
            }
            List users = task.getActors();
            if (users != null) {
                for (String userName : users) {
                    if (userName.contains(":") && actors.contains(userName.split(":")[1])) {
                        return true;
                    }
                    if (!actors.contains(userName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected EventProducer getEventProducer() {
        try {
            if (this.eventProducer == null) {
                this.eventProducer = (EventProducer)Framework.getService(EventProducer.class);
            }
            return this.eventProducer;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get EventProducer service", e);
        }
    }

    public void notifyEventListeners(String name, String comment, String[] recipients, CoreSession session, NuxeoPrincipal principal, DocumentModel doc) throws ClientException {
        DocumentEventContext ctx = new DocumentEventContext(session, (Principal)principal, doc);
        ctx.setProperty("recipients", (Serializable)recipients);
        ctx.getProperties().put("comment", comment);
        try {
            this.getEventProducer().fireEvent(ctx.newEvent(name));
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected void notifyEvent(CoreSession coreSession, DocumentModel document, NuxeoPrincipal principal, Task task, String eventId, Map<String, Serializable> properties, String comment, String category) throws ClientException {
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        EventContextImpl eventContext = null;
        if (document != null) {
            properties.put("repositoryName", (Serializable)((Object)document.getRepositoryName()));
            properties.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
            properties.put("documentLifeCycle", (Serializable)((Object)document.getCurrentLifeCycleState()));
            eventContext = new DocumentEventContext(coreSession, (Principal)principal, document);
        } else {
            eventContext = new EventContextImpl(coreSession, (Principal)principal);
        }
        properties.put("comment", (Serializable)((Object)comment));
        properties.put("category", (Serializable)((Object)category));
        properties.put("taskInstance", (Serializable)task);
        String disableNotif = task.getVariable("disableNotificationService");
        if (disableNotif != null && Boolean.TRUE.equals(Boolean.valueOf(disableNotif))) {
            properties.put("disableNotificationService", Boolean.TRUE);
        }
        eventContext.setProperties(properties);
        Event event = eventContext.newEvent(eventId);
        this.getEventProducer().fireEvent(event);
    }

    public Task getTask(CoreSession coreSession, String taskId) throws ClientException {
        Task task;
        IdRef docRef = new IdRef(taskId);
        DocumentModel taskDoc = coreSession.getDocument((DocumentRef)docRef);
        if (taskDoc != null && (task = (Task)taskDoc.getAdapter(Task.class)) != null) {
            return task;
        }
        return null;
    }

    public void deleteTask(CoreSession coreSession, String taskId) throws ClientException {
        IdRef docRef = new IdRef(taskId);
        UnrestrictedSessionRunner runner = new UnrestrictedSessionRunner(coreSession, (DocumentRef)docRef){
            final /* synthetic */ DocumentRef val$docRef;
            {
                this.val$docRef = documentRef;
                super(x0);
            }

            public void run() throws ClientException {
                this.session.removeDocument(this.val$docRef);
            }
        };
        runner.runUnrestricted();
    }

    public DocumentModel getTargetDocumentModel(Task task, CoreSession coreSession) throws ClientException {
        return coreSession.getDocument((DocumentRef)new IdRef(task.getTargetDocumentId()));
    }

    public List<Task> getCurrentTaskInstances(CoreSession coreSession) throws ClientException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getCurrentTaskInstances(coreSession);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getCurrentTaskInstances(List<String> actors, CoreSession coreSession) throws ClientException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getCurrentTaskInstances(actors, coreSession);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getTaskInstances(DocumentModel dm, NuxeoPrincipal user, CoreSession coreSession) throws ClientException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getTaskInstances(dm, user, coreSession);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    public List<Task> getTaskInstances(DocumentModel dm, List<String> actors, CoreSession coreSession) throws ClientException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (TaskProvider taskProvider : this.tasksProviders.values()) {
            List newTasks = taskProvider.getTaskInstances(dm, actors, coreSession);
            if (newTasks == null) continue;
            tasks.addAll(newTasks);
        }
        return tasks;
    }

    protected List<Task> wrapDocModelInTask(DocumentModelList taskDocuments) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (DocumentModel doc : taskDocuments) {
            tasks.add((Task)doc.getAdapter(Task.class));
        }
        return tasks;
    }

    public String getTaskRootParentPath(CoreSession coreSession) {
        GetTaskRootParentPathUnrestricted runner = new GetTaskRootParentPathUnrestricted(coreSession);
        try {
            runner.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return runner.getParentPath();
    }

    public class GetTaskRootParentPathUnrestricted
    extends UnrestrictedSessionRunner {
        protected DocumentModel taskRootDoc;

        public GetTaskRootParentPathUnrestricted(CoreSession session) {
            super(session);
        }

        public void run() throws ClientException {
            PathRef pathRef = new PathRef(TaskServiceImpl.this.parentPath);
            if (this.session.exists((DocumentRef)pathRef)) {
                this.taskRootDoc = this.session.getDocument((DocumentRef)pathRef);
            } else {
                Path path = new Path(TaskServiceImpl.this.parentPath);
                this.taskRootDoc = this.session.createDocumentModel(path.removeLastSegments(1).toString(), path.lastSegment(), "TaskRoot");
                this.taskRootDoc = this.session.createDocument(this.taskRootDoc);
            }
        }

        public DocumentModel getTaskRootDoc() {
            return this.taskRootDoc;
        }

        public String getParentPath() {
            return this.taskRootDoc.getPathAsString();
        }
    }
}

