/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryProxy;
import org.nuxeo.ecm.directory.ldap.LDAPServerDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class LDAPDirectoryFactory
extends DefaultComponent
implements DirectoryFactory {
    public static final String NAME = "org.nuxeo.ecm.directory.ldap.LDAPDirectoryFactory";
    private static final Log log = LogFactory.getLog(LDAPDirectoryFactory.class);
    private final Map<String, Directory> proxies = new HashMap<String, Directory>();
    private final Map<String, LDAPServerDescriptor> servers = new HashMap<String, LDAPServerDescriptor>();

    public Directory getDirectory(String name) {
        return this.proxies.get(name);
    }

    public List<Directory> getDirectories() {
        ArrayList<Directory> directories = new ArrayList<Directory>();
        directories.addAll(this.proxies.values());
        return directories;
    }

    public LDAPServerDescriptor getServer(String name) {
        return this.servers.get(name);
    }

    public String getName() {
        return NAME;
    }

    public void activate(ComponentContext context) {
        log.info((Object)"component activated");
        this.proxies.clear();
        this.servers.clear();
    }

    public void deactivate(ComponentContext context) {
        log.info((Object)"component deactivated");
        this.proxies.clear();
        this.servers.clear();
    }

    protected static DirectoryServiceImpl getDirectoryService() {
        return (DirectoryServiceImpl)Framework.getLocalService(DirectoryService.class);
    }

    public void registerExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("directories")) {
            this.registerDirectoryExtension(extension);
        } else if (xp.equals("servers")) {
            this.registerServerExtension(extension);
        }
    }

    public void unregisterExtension(Extension extension) throws DirectoryException {
        String xp = extension.getExtensionPoint();
        if (xp.equals("directories")) {
            this.unregisterDirectoryExtension(extension);
        } else if (xp.equals("servers")) {
            this.unregisterServerExtension(extension);
        }
    }

    public void registerServerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            LDAPServerDescriptor descriptor = (LDAPServerDescriptor)contrib;
            String descriptorName = descriptor.getName();
            this.servers.put(descriptorName, descriptor);
            log.info((Object)("server registered: " + descriptorName));
        }
    }

    public void unregisterServerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            LDAPServerDescriptor descriptor = (LDAPServerDescriptor)contrib;
            String descriptorName = descriptor.getName();
            this.servers.remove(descriptorName);
            log.info((Object)("server unregistered: " + descriptorName));
        }
    }

    public void registerDirectoryExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        DirectoryServiceImpl dirService = LDAPDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            LDAPDirectoryDescriptor descriptor = (LDAPDirectoryDescriptor)contrib;
            String descriptorName = descriptor.getName();
            this.proxies.put(descriptorName, new LDAPDirectoryProxy(descriptor));
            dirService.registerDirectory(descriptorName, (DirectoryFactory)this);
            log.info((Object)("directory registered: " + descriptorName));
        }
    }

    public void unregisterDirectoryExtension(Extension extension) throws DirectoryException {
        Object[] contribs = extension.getContributions();
        DirectoryServiceImpl dirService = LDAPDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            LDAPDirectoryDescriptor descriptor = (LDAPDirectoryDescriptor)contrib;
            String directoryName = descriptor.getName();
            dirService.unregisterDirectory(directoryName, (DirectoryFactory)this);
            this.proxies.get(directoryName).shutdown();
            this.proxies.remove(directoryName);
            log.info((Object)("directory unregistered: " + directoryName));
        }
    }

    public void shutdown() throws DirectoryException {
        for (Directory directory : this.proxies.values()) {
            directory.shutdown();
        }
    }
}

