/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.util.Collection;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryCache;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;

public class LDAPDirectoryProxy
implements Directory {
    private final LDAPDirectoryDescriptor descriptor;
    private LDAPDirectory directory;

    public LDAPDirectoryProxy(LDAPDirectoryDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public LDAPDirectory getDirectory() throws DirectoryException {
        if (null == this.directory) {
            try {
                this.directory = new LDAPDirectory(this.descriptor);
            }
            catch (DirectoryException e) {
                throw e;
            }
            catch (ClientException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
        return this.directory;
    }

    public String getName() throws DirectoryException {
        return this.getDirectory().getName();
    }

    public String getSchema() throws DirectoryException {
        return this.getDirectory().getSchema();
    }

    public String getParentDirectory() throws DirectoryException {
        return this.getDirectory().getParentDirectory();
    }

    public String getIdField() throws DirectoryException {
        return this.getDirectory().getIdField();
    }

    public String getPasswordField() throws DirectoryException {
        return this.getDirectory().getPasswordField();
    }

    public Session getSession() throws DirectoryException {
        return this.getDirectory().getSession();
    }

    public void shutdown() throws DirectoryException {
        if (this.directory != null) {
            this.directory.shutdown();
        }
    }

    public Reference getReference(String referenceFieldName) {
        try {
            return this.getDirectory().getReference(referenceFieldName);
        }
        catch (DirectoryException e) {
            return null;
        }
    }

    public Collection<Reference> getReferences() throws DirectoryException {
        return this.getDirectory().getReferences();
    }

    public DirectoryCache getCache() throws DirectoryException {
        return this.getDirectory().getCache();
    }

    public void invalidateDirectoryCache() throws DirectoryException {
        this.getCache().invalidateAll();
    }
}

