/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.fprpc.FPRPCConts;
import org.nuxeo.wss.servlet.HttpServletRequestWrapper;
import org.nuxeo.wss.servlet.WSSFrontFilter;
import org.nuxeo.wss.servlet.config.FilterBindingConfig;
import org.nuxeo.wss.servlet.config.FilterBindingResolver;

public abstract class BaseWSSFilter
implements Filter {
    protected FilterConfig filterConfig;
    protected ServletContext ctx;
    protected String rootFilterTarget = null;
    protected String webDavUrl = "/site/dav";
    public static final String ROOT_FILTER_PARAM = "org.nuxeo.wss.rootFilter";
    public static final String BACKEND_FACTORY_PARAM = "org.nuxeo.wss.backendFactory";
    public static final String FILTER_FORWARD_PARAM = "org.nuxeo.wss.forwardedFilter";
    public static final String WSSFORWARD_KEY = "WSSForward";
    public static final String DEFAULT_WEBDAV_URL = "/site/dav";
    public static final String NUXEO_ROOT_URL = "/nuxeo";
    public static final int NUXEO_ROOT_URL_LEN = "/nuxeo".length();
    private static final Log log = LogFactory.getLog(WSSFrontFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            String forward;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String uri = httpRequest.getRequestURI();
            if (this.isRootFilter() && (forward = httpRequest.getParameter(WSSFORWARD_KEY)) != null) {
                httpResponse.sendRedirect(forward);
                return;
            }
            try {
                if (this.isWebDavRequest(httpRequest) && !uri.startsWith(NUXEO_ROOT_URL + this.webDavUrl)) {
                    this.handleWebDavCall(httpRequest, httpResponse);
                    return;
                }
            }
            catch (Exception e) {
                throw new ServletException("error processing request", (Throwable)e);
            }
            if (this.isRootFilter() && uri.startsWith(this.getRootFilterTarget())) {
                log.debug((Object)"Let WSS request to back filter");
                chain.doFilter(request, response);
                return;
            }
            Object forwardedConfig = httpRequest.getAttribute(FILTER_FORWARD_PARAM);
            if (forwardedConfig != null) {
                try {
                    this.handleForwardedCall(httpRequest, httpResponse, (FilterBindingConfig)forwardedConfig);
                }
                catch (Exception e) {
                    throw new ServletException("Error processing WSS request", (Throwable)e);
                }
            }
            FilterBindingConfig config = null;
            try {
                config = FilterBindingResolver.getBinding(httpRequest);
            }
            catch (Exception e) {
                throw new ServletException("Error processing WSS request", (Throwable)e);
            }
            if (config != null) {
                try {
                    if (this.isRootFilter()) {
                        log.debug((Object)"Forward call to backend filter");
                        httpRequest.setAttribute(FILTER_FORWARD_PARAM, (Object)config);
                        this.doForward(httpRequest, httpResponse, config);
                    } else {
                        this.handleWSSCall(httpRequest, httpResponse, config);
                    }
                }
                catch (Exception e) {
                    throw new ServletException("Error processing WSS request", (Throwable)e);
                }
                return;
            }
            chain.doFilter(request, response);
        }
    }

    protected String getRootFilterTarget() {
        return this.rootFilterTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig != null) {
            this.ctx = filterConfig.getServletContext();
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.initHandlers(filterConfig);
            this.filterConfig = filterConfig;
            if (filterConfig != null) {
                this.initBackend(filterConfig);
            }
        }
    }

    protected void handleWebDavCall(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String destination = httpRequest.getHeader("Destination");
        if (StringUtils.isNotEmpty((String)destination)) {
            destination = this.resolveDestinationPath(destination);
            HttpServletRequestWrapper httpRequestWrapper = new HttpServletRequestWrapper((HttpServletRequest)httpRequest);
            httpRequestWrapper.setHeader("destination", destination);
            httpRequest = httpRequestWrapper;
        }
        if (this.isMSWebDavRequest((HttpServletRequest)httpRequest)) {
            httpResponse.setHeader("Server", "Microsoft-IIS/6.0");
            httpResponse.setHeader("X-Powered-By", "ASP.NET");
            httpResponse.setHeader("MicrosoftSharePointTeamServices", "12.0.0.6421");
            httpResponse.setHeader("Content-Type", "text/xml");
            httpResponse.setHeader("Cache-Control", "no-cache");
            httpResponse.setHeader("Public-Extension", "http://schemas.microsoft.com/repl-2");
        }
        String createdURL = this.createPathToWebDav(httpRequest.getRequestURI());
        RequestDispatcher dispatcher = this.ctx.getRequestDispatcher(createdURL);
        dispatcher.forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private String createPathToWebDav(String basePath) {
        if (basePath.contains(NUXEO_ROOT_URL + this.webDavUrl)) {
            return basePath;
        }
        if (basePath.startsWith(NUXEO_ROOT_URL)) {
            return this.webDavUrl + basePath.substring(NUXEO_ROOT_URL_LEN);
        }
        return this.webDavUrl;
    }

    private boolean isWebDavRequest(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return StringUtils.isNotEmpty((String)ua) && ua.contains(FPRPCConts.MS_WEBDAV_USERAGENT);
    }

    private boolean isMSWebDavRequest(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return ua != null && ua.contains(FPRPCConts.MS_WEBDAV_USERAGENT);
    }

    private String resolveDestinationPath(String destination) {
        int index = destination.indexOf(NUXEO_ROOT_URL);
        String prefix = destination.substring(0, index + NUXEO_ROOT_URL_LEN);
        String suffix = destination.substring(index + NUXEO_ROOT_URL_LEN);
        return prefix + this.webDavUrl + suffix;
    }

    protected void handleForwardedCall(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterBindingConfig forwardedConfig) throws Exception {
        log.debug((Object)"handle call forwarded by root filter");
        this.handleWSSCall(httpRequest, httpResponse, forwardedConfig);
    }

    protected abstract void initBackend(FilterConfig var1);

    protected abstract void initHandlers(FilterConfig var1);

    protected abstract boolean isRootFilter();

    protected abstract void doForward(HttpServletRequest var1, HttpServletResponse var2, FilterBindingConfig var3) throws Exception;

    protected abstract void handleWSSCall(HttpServletRequest var1, HttpServletResponse var2, FilterBindingConfig var3) throws Exception;

    public void destroy() {
    }
}

