/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentPersistence;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class OSGiRuntimeService
extends AbstractRuntimeService
implements FrameworkListener {
    public static final ComponentName FRAMEWORK_STARTED_COMP = new ComponentName("org.nuxeo.runtime.started");
    public static final String PROP_HOME_DIR = "org.nuxeo.runtime.home";
    public static final String PROP_INSTALL_DIR = "INSTALL_DIR";
    public static final String PROP_CONFIG_DIR = "CONFIG_DIR";
    public static final String PROP_HOST_ADAPTER = "HOST_ADAPTER";
    public static final String PROP_NUXEO_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String NAME = "OSGi NXRuntime";
    public static final Version VERSION = Version.parseString("1.4.0");
    private static final Log log = LogFactory.getLog(OSGiRuntimeService.class);
    private final BundleContext bundleContext;
    private final Map<String, RuntimeContext> contexts;
    private boolean appStarted = false;
    final Map<String, Bundle> bundles;
    final ComponentPersistence persistence;

    public OSGiRuntimeService(BundleContext context) {
        this(new OSGiRuntimeContext(context.getBundle()), context);
    }

    public OSGiRuntimeService(OSGiRuntimeContext runtimeContext, BundleContext context) {
        super(runtimeContext);
        this.bundleContext = context;
        this.bundles = new ConcurrentHashMap<String, Bundle>();
        this.contexts = new ConcurrentHashMap<String, RuntimeContext>();
        String bindAddress = context.getProperty(PROP_NUXEO_BIND_ADDRESS);
        if (bindAddress != null) {
            this.properties.put(PROP_NUXEO_BIND_ADDRESS, bindAddress);
        }
        String homeDir = this.getProperty(PROP_HOME_DIR);
        log.debug((Object)("Home directory: " + homeDir));
        this.workingDir = homeDir != null ? new File(homeDir) : this.bundleContext.getDataFile("/");
        Environment env = Environment.getDefault();
        if (env == null) {
            Environment.setDefault((Environment)new Environment(this.workingDir));
        }
        this.workingDir.mkdirs();
        this.persistence = new ComponentPersistence(this);
        log.debug((Object)("Working directory: " + this.workingDir));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public Bundle getBundle(String symbolicName) {
        return this.bundles.get(symbolicName);
    }

    public Map<String, Bundle> getBundlesMap() {
        return this.bundles;
    }

    public ComponentPersistence getComponentPersistence() {
        return this.persistence;
    }

    public synchronized RuntimeContext createContext(Bundle bundle) throws Exception {
        RuntimeContext ctx = this.contexts.get(bundle.getSymbolicName());
        if (ctx == null) {
            ctx = new OSGiRuntimeContext(bundle);
            this.contexts.put(bundle.getSymbolicName(), ctx);
            this.loadComponents(bundle, ctx);
        }
        return ctx;
    }

    public synchronized void destroyContext(Bundle bundle) {
        RuntimeContext ctx = this.contexts.remove(bundle.getSymbolicName());
        if (ctx != null) {
            ctx.destroy();
        }
    }

    public synchronized RuntimeContext getContext(Bundle bundle) {
        return this.contexts.get(bundle.getSymbolicName());
    }

    public synchronized RuntimeContext getContext(String symbolicName) {
        return this.contexts.get(symbolicName);
    }

    @Override
    protected void doStart() throws Exception {
        this.bundleContext.addFrameworkListener((FrameworkListener)this);
        this.loadConfig();
        this.loadComponents(this.bundleContext.getBundle(), this.context);
    }

    @Override
    protected void doStop() throws Exception {
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        super.doStop();
        this.context.destroy();
    }

    protected void loadComponents(Bundle bundle, RuntimeContext ctx) throws Exception {
        String list = OSGiRuntimeService.getComponentsList(bundle);
        String name = bundle.getSymbolicName();
        log.debug((Object)("Bundle: " + name + " components: " + list));
        if (list == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(list, ", \t\n\r\f");
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            URL url = bundle.getEntry(path);
            log.debug((Object)("Loading component for: " + name + " path: " + path + " url: " + url));
            if (url != null) {
                try {
                    ctx.deploy(url);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Error deploying resource: " + url));
                    Framework.handleDevError(e);
                    throw e;
                }
            }
            String message = "Unknown component '" + path + "' referenced by bundle '" + name + "'";
            log.error((Object)(message + ". Check the MANIFEST.MF"));
            Framework.handleDevError(null);
            this.warnings.add(message);
        }
    }

    public static String getComponentsList(Bundle bundle) {
        return (String)bundle.getHeaders().get("Nuxeo-Component");
    }

    protected boolean loadConfigurationFromProvider() throws Exception {
        Iterable provider = Environment.getDefault().getConfigurationProvider();
        if (provider == null) {
            return false;
        }
        Iterator it = provider.iterator();
        ArrayList<URL> props = new ArrayList<URL>();
        ArrayList<URL> xmls = new ArrayList<URL>();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            String path = url.getPath();
            if (path.endsWith("-config.xml")) {
                xmls.add(url);
                continue;
            }
            if (!path.endsWith(".properties")) continue;
            props.add(url);
        }
        Comparator<URL> comp = new Comparator<URL>(){

            @Override
            public int compare(URL o1, URL o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        };
        Collections.sort(xmls, comp);
        for (URL url : props) {
            this.loadProperties(url);
        }
        for (URL url : xmls) {
            this.context.deploy(url);
        }
        return true;
    }

    protected void loadConfig() throws Exception {
        Environment env = Environment.getDefault();
        if (env == null) {
            log.warn((Object)"Configuration: no host application");
            return;
        }
        log.info((Object)("Configuration: host application: " + env.getHostApplicationName()));
        File blacklistFile = new File(env.getConfig(), "blacklist");
        if (blacklistFile.isFile()) {
            List lines = FileUtils.readLines((File)blacklistFile);
            HashSet<String> blacklist = new HashSet<String>();
            for (String line : lines) {
                if ((line = line.trim()).length() <= 0) continue;
                blacklist.add(line);
            }
            this.manager.setBlacklist(new HashSet<String>(lines));
        }
        if (this.loadConfigurationFromProvider()) {
            return;
        }
        String configDir = this.bundleContext.getProperty(PROP_CONFIG_DIR);
        if (configDir != null && configDir.contains(":/")) {
            log.debug((Object)("Configuration: " + configDir));
            URL url = new URL(configDir);
            log.debug((Object)("Configuration:   loading properties url: " + configDir));
            this.loadProperties(url);
            return;
        }
        boolean isNotJBoss4 = !OSGiRuntimeService.isJBoss4(env);
        File dir = env.getConfig();
        String[] names = dir.list();
        if (names != null) {
            Arrays.sort(names, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            OSGiRuntimeService.printDeploymentOrderInfo(names);
            for (String name : names) {
                File file;
                if (name.endsWith("-config.xml") || name.endsWith("-bundle.xml")) {
                    if (!isNotJBoss4) continue;
                    file = new File(dir, name);
                    log.debug((Object)("Configuration: deploy config component: " + name));
                    this.context.deploy(file.toURI().toURL());
                    continue;
                }
                if (name.endsWith(".config") || name.endsWith(".ini") || name.endsWith(".properties")) {
                    file = new File(dir, name);
                    log.debug((Object)("Configuration: loading properties: " + name));
                    this.loadProperties(file);
                    continue;
                }
                log.debug((Object)("Configuration: ignoring: " + name));
            }
        } else if (dir.isFile()) {
            log.debug((Object)("Configuration: loading properties: " + dir));
            this.loadProperties(dir);
        } else {
            log.debug((Object)"Configuration: no configuration file found");
        }
        this.loadDefaultConfig();
    }

    protected static void printDeploymentOrderInfo(String[] fileNames) {
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            for (String fileName : fileNames) {
                buf.append("\n\t" + fileName);
            }
            log.debug((Object)("Deployment order of configuration files: " + buf.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadProperties() throws Exception {
        File dir = Environment.getDefault().getConfig();
        String[] names = dir.list();
        if (names != null) {
            Arrays.sort(names, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            Properties props = new Properties();
            for (String name : names) {
                if (!name.endsWith(".config") && !name.endsWith(".ini") && !name.endsWith(".properties")) continue;
                FileInputStream in = new FileInputStream(new File(dir, name));
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
            }
            this.properties = props;
        }
    }

    protected void loadDefaultConfig() {
        String varName = "org.nuxeo.ecm.contextPath";
        if (Framework.getProperty(varName) == null) {
            this.properties.setProperty(varName, "/nuxeo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.loadProperties(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            this.loadProperties(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void loadProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            this.properties.put(prop.getKey().toString(), prop.getValue().toString());
        }
    }

    @Override
    public String getProperty(String name, String defValue) {
        String value = this.properties.getProperty(name);
        if (value == null && (value = this.bundleContext.getProperty(name)) == null) {
            return defValue == null ? null : this.expandVars(defValue);
        }
        if (value.startsWith("$") && value.equals("${" + name + "}")) {
            return value;
        }
        return this.expandVars(value);
    }

    protected void notifyComponentsOnStarted() {
        ArrayList<RegistrationInfo> ris = new ArrayList<RegistrationInfo>(this.manager.getRegistrations());
        Collections.sort(ris, new RIApplicationStartedComparator());
        for (RegistrationInfo ri : ris) {
            try {
                ri.notifyApplicationStarted();
            }
            catch (Exception e) {
                log.error((Object)("Failed to notify component '" + ri.getName() + "' on application started"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireApplicationStarted() {
        OSGiRuntimeService oSGiRuntimeService = this;
        synchronized (oSGiRuntimeService) {
            if (this.appStarted) {
                return;
            }
            this.appStarted = true;
        }
        try {
            this.persistence.loadPersistedComponents();
        }
        catch (Exception e) {
            log.error((Object)"Failed to load persisted components", (Throwable)e);
        }
        this.deployFrameworkStartedComponent();
        this.notifyComponentsOnStarted();
        this.printStatusMessage();
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            this.fireApplicationStarted();
        }
    }

    private void printStatusMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Nuxeo EP Started\n");
        if (this.getStatusMessage(msg)) {
            log.info((Object)msg);
        } else {
            log.error((Object)msg);
        }
    }

    public boolean getStatusMessage(StringBuilder msg) {
        String hr = "======================================================================";
        msg.append(hr).append("\n= Nuxeo EP Started\n");
        if (!this.warnings.isEmpty()) {
            msg.append(hr).append("\n= Component Loading Errors:\n");
            for (String warning : this.warnings) {
                msg.append("  * ").append(warning).append('\n');
            }
        }
        Map<ComponentName, Set<ComponentName>> pendingRegistrations = this.manager.getPendingRegistrations();
        Collection<ComponentName> activatingRegistrations = this.manager.getActivatingRegistrations();
        msg.append(hr).append("\n= Component Loading Status: Pending: ").append(pendingRegistrations.size()).append(" / Unstarted: ").append(activatingRegistrations.size()).append(" / Total: ").append(this.manager.getRegistrations().size()).append('\n');
        for (Map.Entry<ComponentName, Set<ComponentName>> e : pendingRegistrations.entrySet()) {
            msg.append("  * ").append(e.getKey()).append(" requires ").append(e.getValue()).append('\n');
        }
        for (ComponentName componentName : activatingRegistrations) {
            msg.append("  - ").append(componentName).append('\n');
        }
        msg.append(hr);
        return this.warnings.isEmpty() && pendingRegistrations.isEmpty() && activatingRegistrations.isEmpty();
    }

    protected void deployFrameworkStartedComponent() {
        RegistrationInfoImpl ri = new RegistrationInfoImpl(FRAMEWORK_STARTED_COMP);
        ri.setContext(this.context);
        this.manager.register(ri);
    }

    public Bundle findHostBundle(Bundle bundle) {
        String hostId = (String)bundle.getHeaders().get("Fragment-Host");
        log.debug((Object)("Looking for host bundle: " + bundle.getSymbolicName() + " host id: " + hostId));
        if (hostId != null) {
            RuntimeContext ctx;
            int p = hostId.indexOf(59);
            if (p > -1) {
                hostId = hostId.substring(0, p);
            }
            if ((ctx = this.contexts.get(hostId)) != null) {
                log.debug((Object)("Context was found for host id: " + hostId));
                return ctx.getBundle();
            }
            log.warn((Object)("No context found for host id: " + hostId));
        }
        return null;
    }

    protected File getEclipseBundleFileUsingReflection(Bundle bundle) {
        try {
            Object proxy = bundle.getClass().getMethod("getLoaderProxy", new Class[0]).invoke((Object)bundle, new Object[0]);
            Object loader = proxy.getClass().getMethod("getBundleLoader", new Class[0]).invoke(proxy, new Object[0]);
            URL root = (URL)loader.getClass().getMethod("findResource", String.class).invoke(loader, "/");
            Field field = root.getClass().getDeclaredField("handler");
            field.setAccessible(true);
            Object handler = field.get(root);
            Field entryField = handler.getClass().getSuperclass().getDeclaredField("bundleEntry");
            entryField.setAccessible(true);
            Object entry = entryField.get(handler);
            Field fileField = entry.getClass().getDeclaredField("file");
            fileField.setAccessible(true);
            return (File)fileField.get(entry);
        }
        catch (Throwable e) {
            log.error((Object)("Cannot access to eclipse bundle system files of " + bundle.getSymbolicName()));
            return null;
        }
    }

    @Override
    public File getBundleFile(Bundle bundle) {
        File file;
        String location = bundle.getLocation();
        String vendor = Framework.getProperty("org.osgi.framework.vendor");
        String name = bundle.getSymbolicName();
        if ("Eclipse".equals(vendor)) {
            log.debug((Object)("getBundleFile (Eclipse): " + name + "->" + location));
            return this.getEclipseBundleFileUsingReflection(bundle);
        }
        if (location.startsWith("file:")) {
            try {
                file = FileUtils.urlToFile((String)location);
            }
            catch (Exception e) {
                log.error((Object)("getBundleFile: Unable to create  for bundle: " + name + " as URI: " + location));
                return null;
            }
        }
        try {
            file = new File(location);
        }
        catch (Exception e) {
            log.error((Object)("getBundleFile: Unable to create  for bundle: " + name + " as file: " + location));
            return null;
        }
        if (file != null && file.exists()) {
            log.debug((Object)("getBundleFile: " + name + " bound to file: " + file));
            return file;
        }
        log.debug((Object)("getBundleFile: " + name + " cannot bind to nonexistent file: " + file));
        return null;
    }

    public static final boolean isJBoss4(Environment env) {
        if (env == null) {
            return false;
        }
        String hn = env.getHostApplicationName();
        String hv = env.getHostApplicationVersion();
        if (hn == null || hv == null) {
            return false;
        }
        return "JBoss".equals(hn) && hv.startsWith("4");
    }

    protected static class RIApplicationStartedComparator
    implements Comparator<RegistrationInfo> {
        protected RIApplicationStartedComparator() {
        }

        @Override
        public int compare(RegistrationInfo r1, RegistrationInfo r2) {
            int cmp = r2.getApplicationStartedOrder() - r1.getApplicationStartedOrder();
            if (cmp == 0) {
                cmp = r2.getName().getName().compareTo(r1.getName().getName());
            }
            return cmp;
        }
    }
}

