/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.DefaultStreamBlob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class SQLBlob
extends DefaultStreamBlob
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean IS_STREAMING_ENABLED = Boolean.parseBoolean(Framework.getProperty((String)"org.nuxeo.ecm.core.storage.sql.blob_streaming", (String)"true"));
    protected final Binary binary;

    public SQLBlob(Binary binary, String filename, String mimeType, String encoding, String digest) {
        this.binary = binary;
        this.setFilename(filename);
        this.setMimeType(mimeType);
        this.setEncoding(encoding);
        this.setDigest(digest);
    }

    public long getLength() {
        return this.binary.getLength();
    }

    public InputStream getStream() throws IOException {
        return this.binary.getStream();
    }

    public boolean isPersistent() {
        return true;
    }

    public Blob persist() {
        return this;
    }

    public Binary getBinary() {
        return this.binary;
    }

    public Object writeReplace() throws ObjectStreamException {
        if (IS_STREAMING_ENABLED) {
            StreamSource src = this.binary.getStreamSource();
            return new StreamingBlob(src, this.getMimeType(), this.getEncoding(), this.getFilename(), this.getDigest());
        }
        return this;
    }
}

