/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.net.URI;
import java.security.Principal;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.AdapterResource;
import org.nuxeo.ecm.webengine.model.LinkDescriptor;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.View;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.AbstractWebContext;
import org.nuxeo.ecm.webengine.model.impl.AdapterTypeImpl;
import org.nuxeo.ecm.webengine.security.PermissionService;

public abstract class AbstractResource<T extends ResourceType>
implements Resource {
    protected WebContext ctx;
    protected AbstractResource<?> next;
    protected AbstractResource<?> prev;
    protected String path;
    protected T type;

    @Override
    public Resource initialize(WebContext ctx, ResourceType type, Object ... args) {
        this.ctx = ctx;
        this.type = type;
        this.path = (String)ctx.getUriInfo().getMatchedURIs().get(0);
        if (this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
        StringBuilder buf = new StringBuilder(64).append(ctx.getBasePath());
        if (!this.path.startsWith("/")) {
            buf.append('/');
        }
        this.path = buf.append(this.path).toString();
        if (!this.type.getGuard().check(this)) {
            throw new WebSecurityException("Failed to initialize object: " + this.path + ". Object is not accessible in the current context", this.path);
        }
        this.initialize(args);
        return this;
    }

    protected void initialize(Object ... args) {
    }

    @Override
    public boolean isAdapter() {
        return this.type.getClass() == AdapterTypeImpl.class;
    }

    @Override
    public boolean isRoot() {
        return this == this.ctx.getRoot();
    }

    @Override
    public void setRoot(boolean isRoot) {
        AbstractWebContext ctx = (AbstractWebContext)this.ctx;
        if (isRoot) {
            ctx.root = this;
        } else if (ctx.root == this) {
            ctx.root = null;
        }
    }

    @Override
    public boolean isInstanceOf(String type) {
        return this.type.isDerivedFrom(type);
    }

    @Override
    public Response redirect(String uri) {
        try {
            if (!uri.contains("://")) {
                uri = uri.startsWith("/") ? this.ctx.getServerURL().append(uri).toString() : this.ctx.getServerURL().append('/').append(uri).toString();
            }
            return Response.seeOther((URI)new URI(uri)).build();
        }
        catch (Exception e) {
            throw WebException.wrap(e);
        }
    }

    @Override
    public AdapterResource getActiveAdapter() {
        return this.next != null && this.next.isAdapter() ? (AdapterResource)((Object)this.next) : null;
    }

    @Override
    public void dispose() {
        this.ctx = null;
        this.type = null;
        this.path = null;
    }

    @Override
    public Set<String> getFacets() {
        return this.type.getFacets();
    }

    @Override
    public boolean hasFacet(String facet) {
        return this.type.hasFacet(facet);
    }

    public T getType() {
        return this.type;
    }

    @Override
    public WebContext getContext() {
        return this.ctx;
    }

    @Override
    public Module getModule() {
        return this.ctx.getModule();
    }

    @Override
    public Resource getNext() {
        return this.next;
    }

    @Override
    public void setNext(Resource next) {
        this.next = (AbstractResource)next;
    }

    @Override
    public Resource getPrevious() {
        return this.prev;
    }

    @Override
    public void setPrevious(Resource previous) {
        this.prev = (AbstractResource)previous;
    }

    @Override
    public String getName() {
        int e = this.path.endsWith("/") ? this.path.length() - 1 : this.path.length();
        int p = this.path.lastIndexOf(47, e - 1);
        return p > -1 ? this.path.substring(p + 1) : this.path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getTrailingPath() {
        String urlPath;
        int len = this.path.length();
        return len < (urlPath = this.ctx.getUrlPath()).length() ? urlPath.substring(len) : "/";
    }

    @Override
    public String getNextSegment() {
        String p = this.getTrailingPath();
        if (p != null && !"/".equals(p)) {
            int s = p.startsWith("/") ? 1 : 0;
            int k = p.indexOf(47, s);
            if (k == -1) {
                return s > 0 ? p.substring(s) : p;
            }
            return p.substring(s, k);
        }
        return null;
    }

    @Override
    public String getURL() {
        return this.ctx.getServerURL().append(this.path).toString();
    }

    @Override
    public List<LinkDescriptor> getLinks(String category) {
        return this.ctx.getModule().getActiveLinks(this, category);
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter == CoreSession.class) {
            return adapter.cast(this.ctx.getCoreSession());
        }
        if (adapter == Principal.class) {
            return adapter.cast(this.ctx.getPrincipal());
        }
        if (adapter == WebContext.class) {
            return adapter.cast(this.ctx);
        }
        if (Resource.class.isAssignableFrom(adapter)) {
            return adapter.cast(this);
        }
        return null;
    }

    @Override
    public Resource newObject(String type, Object ... args) {
        return this.ctx.newObject(type, args);
    }

    @Override
    public AdapterResource newAdapter(String type, Object ... args) {
        return this.ctx.newAdapter(this, type, args);
    }

    @Override
    public Template getView(String viewId) {
        return new View((Resource)this, viewId).resolve();
    }

    @Override
    public Template getTemplate(String fileName) {
        return new Template((Resource)this, this.getModule().getFile(fileName));
    }

    @Override
    public boolean checkGuard(String guard) throws ParseException {
        return PermissionService.parse(guard).check(this);
    }

    public String toString() {
        return this.type.getName() + " [" + this.path + "]";
    }
}

