/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.ecm.webapp.tree.TreeActions;
import org.nuxeo.ecm.webapp.tree.TreeInvalidatorBean;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.component.UITree;
import org.richfaces.event.NodeExpandedEvent;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="treeActions")
@Install(precedence=10)
public class TreeActionsBean
implements TreeActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TreeActionsBean.class);
    public static final String NODE_SELECTED_MARKER = TreeActionsBean.class.getName() + "_NODE_SELECTED_MARKER";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected Map<String, List<DocumentTreeNode>> trees = new HashMap<String, List<DocumentTreeNode>>();
    protected String currentDocumentPath;
    @In(create=true, required=false)
    protected Boolean isUserWorkspace;
    protected String userWorkspacePath;
    @In(create=true)
    protected TreeInvalidatorBean treeInvalidator;

    @Override
    public List<DocumentTreeNode> getTreeRoots() throws ClientException {
        return this.getTreeRoots(false);
    }

    public List<DocumentTreeNode> getTreeRoots(String treeName) throws ClientException {
        return this.getTreeRoots(false, treeName);
    }

    protected List<DocumentTreeNode> getTreeRoots(boolean showRoot, String treeName) throws ClientException {
        return this.getTreeRoots(showRoot, this.navigationContext.getCurrentDocument(), treeName);
    }

    protected List<DocumentTreeNode> getTreeRoots(boolean showRoot) throws ClientException {
        return this.getTreeRoots(showRoot, this.navigationContext.getCurrentDocument(), "navigation");
    }

    protected List<DocumentTreeNode> getTreeRoots(boolean showRoot, DocumentModel currentDocument) throws ClientException {
        return this.getTreeRoots(showRoot, currentDocument, "navigation");
    }

    protected List<DocumentTreeNode> getTreeRoots(boolean showRoot, DocumentModel currentDocument, String treeName) throws ClientException {
        List<DocumentTreeNode> currentTree;
        if (this.treeInvalidator.needsInvalidation()) {
            this.reset();
            this.treeInvalidator.invalidationDone();
        }
        if ((currentTree = this.trees.get(treeName)) == null) {
            currentTree = new ArrayList<DocumentTreeNode>();
            DocumentModel firstAccessibleParent = null;
            if (currentDocument != null) {
                if (this.isUserWorkspace != null && this.isUserWorkspace.booleanValue()) {
                    firstAccessibleParent = this.documentManager.getDocument((DocumentRef)new PathRef(this.userWorkspacePath));
                } else {
                    List parents = this.documentManager.getParentDocuments(currentDocument.getRef());
                    if (!parents.isEmpty()) {
                        firstAccessibleParent = (DocumentModel)parents.get(0);
                    } else if (!"Root".equals(currentDocument.getType()) && currentDocument.isFolder()) {
                        firstAccessibleParent = currentDocument;
                    } else if (showRoot) {
                        firstAccessibleParent = currentDocument;
                    }
                }
            }
            if (firstAccessibleParent != null) {
                Filter filter = null;
                Filter leafFilter = null;
                Sorter sorter = null;
                String pageProvider = null;
                QueryModel queryModel = null;
                QueryModel orderableQueryModel = null;
                try {
                    TreeManager treeManager = (TreeManager)Framework.getService(TreeManager.class);
                    filter = treeManager.getFilter(treeName);
                    leafFilter = treeManager.getLeafFilter(treeName);
                    sorter = treeManager.getSorter(treeName);
                    pageProvider = treeManager.getPageProviderName(treeName);
                    QueryModelDescriptor queryModelDescriptor = treeManager.getQueryModelDescriptor(treeName);
                    queryModel = queryModelDescriptor == null ? null : new QueryModel(queryModelDescriptor);
                    QueryModelDescriptor orderableQueryModelDescriptor = treeManager.getOrderableQueryModelDescriptor(treeName);
                    orderableQueryModel = orderableQueryModelDescriptor == null ? null : new QueryModel(orderableQueryModelDescriptor);
                }
                catch (Exception e) {
                    log.error((Object)"Could not fetch filter or sorter for tree ", (Throwable)e);
                }
                DocumentTreeNodeImpl treeRoot = null;
                treeRoot = pageProvider == null ? new DocumentTreeNodeImpl(this.documentManager.getSessionId(), firstAccessibleParent, filter, leafFilter, sorter, queryModel, orderableQueryModel) : new DocumentTreeNodeImpl(this.documentManager.getSessionId(), firstAccessibleParent, filter, leafFilter, sorter, pageProvider);
                currentTree.add(treeRoot);
                log.debug((Object)("Tree initialized with document: " + firstAccessibleParent.getId()));
            } else {
                log.debug((Object)"Could not initialize the navigation tree: no parent found for current document");
            }
            this.trees.put(treeName, currentTree);
        }
        return this.trees.get(treeName);
    }

    @Override
    public void changeExpandListener(NodeExpandedEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.put(NODE_SELECTED_MARKER, Boolean.TRUE);
    }

    protected Boolean isNodeExpandEvent() {
        ExternalContext externalContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            return Boolean.TRUE.equals(externalContext.getRequestMap().get(NODE_SELECTED_MARKER));
        }
        return false;
    }

    protected String getCurrentDocumentPath() {
        DocumentModel currentDoc;
        if (this.currentDocumentPath == null && (currentDoc = this.navigationContext.getCurrentDocument()) != null) {
            this.currentDocumentPath = currentDoc.getPathAsString();
        }
        return this.currentDocumentPath;
    }

    @Override
    public Boolean adviseNodeOpened(UITree treeComponent) {
        Object value;
        if (!this.isNodeExpandEvent().booleanValue() && (value = treeComponent.getRowData()) instanceof DocumentTreeNode) {
            DocumentTreeNode treeNode = (DocumentTreeNode)value;
            String nodePath = treeNode.getPath();
            String currentDocPath = this.getCurrentDocumentPath();
            if (currentDocPath != null && nodePath != null && currentDocPath.startsWith(nodePath) && ((currentDocPath + '/').startsWith(nodePath + '/') || "/".equals(nodePath))) {
                return true;
            }
        }
        return null;
    }

    @Override
    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetCurrentDocumentData() {
        this.currentDocumentPath = null;
        for (List<DocumentTreeNode> tree : this.trees.values()) {
            if (tree == null || !tree.isEmpty()) continue;
            Object var2_2 = null;
        }
    }

    @Override
    @Observer(value={"goHome", "domainSelectionChanged", "documentChanged", "documentSecurityChanged", "documentChildrenChanged"}, create=false)
    @BypassInterceptors
    public void reset() {
        this.trees.clear();
        this.resetCurrentDocumentData();
    }

    @Observer(value={"personnalWorkspace"}, create=false)
    public void switchToUserWorkspace() {
        this.userWorkspacePath = this.getCurrentDocumentPath();
        this.reset();
    }

    @Observer(value={"goHome"}, create=false)
    @BypassInterceptors
    public void switchToDocumentBase() {
    }

    public String forceTreeRefresh() throws IOException {
        this.resetCurrentDocumentData();
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setContentType("application/xml; charset=UTF-8");
        response.getWriter().write("<response>OK</response>");
        context.responseComplete();
        return null;
    }
}

