/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.Set;
import org.apache.shindig.gadgets.templates.DefaultTemplateProcessor;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.FlashTagHandler;
import org.apache.shindig.gadgets.templates.tags.HtmlTagHandler;
import org.apache.shindig.gadgets.templates.tags.IfTagHandler;
import org.apache.shindig.gadgets.templates.tags.RenderTagHandler;
import org.apache.shindig.gadgets.templates.tags.RepeatTagHandler;
import org.apache.shindig.gadgets.templates.tags.TagHandler;
import org.apache.shindig.gadgets.templates.tags.VariableTagHandler;

public class TemplateModule
extends AbstractModule {
    protected void configure() {
        this.bind(TemplateProcessor.class).to(DefaultTemplateProcessor.class);
        this.bind((TypeLiteral)new TypeLiteral<Set<TagHandler>>(){}).toProvider(TagHandlersProvider.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TagHandlersProvider
    implements Provider<Set<TagHandler>> {
        private final Set<TagHandler> handlers;

        @Inject
        public TagHandlersProvider(HtmlTagHandler htmlHandler, IfTagHandler ifHandler, RepeatTagHandler repeatHandler, RenderTagHandler renderHandler, FlashTagHandler flashHandler, VariableTagHandler variableHandler) {
            this.handlers = ImmutableSet.of((Object[])new TagHandler[]{htmlHandler, ifHandler, repeatHandler, renderHandler, flashHandler, variableHandler});
        }

        public Set<TagHandler> get() {
            return this.handlers;
        }
    }
}

