/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.OperationContribution;
import org.nuxeo.ecm.automation.core.TypeAdapterContribution;
import org.nuxeo.ecm.automation.core.events.EventHandler;
import org.nuxeo.ecm.automation.core.events.EventHandlerRegistry;
import org.nuxeo.ecm.automation.core.events.operations.FireEvent;
import org.nuxeo.ecm.automation.core.impl.OperationServiceImpl;
import org.nuxeo.ecm.automation.core.operations.FetchContextBlob;
import org.nuxeo.ecm.automation.core.operations.FetchContextDocument;
import org.nuxeo.ecm.automation.core.operations.RestoreBlobInput;
import org.nuxeo.ecm.automation.core.operations.RestoreBlobsInput;
import org.nuxeo.ecm.automation.core.operations.RestoreDocumentInput;
import org.nuxeo.ecm.automation.core.operations.RestoreDocumentsInput;
import org.nuxeo.ecm.automation.core.operations.RunInputScript;
import org.nuxeo.ecm.automation.core.operations.RunScript;
import org.nuxeo.ecm.automation.core.operations.SetInputAsVar;
import org.nuxeo.ecm.automation.core.operations.SetVar;
import org.nuxeo.ecm.automation.core.operations.blob.AttachBlob;
import org.nuxeo.ecm.automation.core.operations.blob.BlobToFile;
import org.nuxeo.ecm.automation.core.operations.blob.BlobToPDF;
import org.nuxeo.ecm.automation.core.operations.blob.CreateBlob;
import org.nuxeo.ecm.automation.core.operations.blob.CreateZip;
import org.nuxeo.ecm.automation.core.operations.blob.GetDocumentBlob;
import org.nuxeo.ecm.automation.core.operations.blob.GetDocumentBlobs;
import org.nuxeo.ecm.automation.core.operations.blob.PostBlob;
import org.nuxeo.ecm.automation.core.operations.blob.SetBlobFileName;
import org.nuxeo.ecm.automation.core.operations.document.CheckInDocument;
import org.nuxeo.ecm.automation.core.operations.document.CheckOutDocument;
import org.nuxeo.ecm.automation.core.operations.document.CopyDocument;
import org.nuxeo.ecm.automation.core.operations.document.CreateDocument;
import org.nuxeo.ecm.automation.core.operations.document.CreateVersion;
import org.nuxeo.ecm.automation.core.operations.document.DeleteDocument;
import org.nuxeo.ecm.automation.core.operations.document.FetchByProperty;
import org.nuxeo.ecm.automation.core.operations.document.FetchDocument;
import org.nuxeo.ecm.automation.core.operations.document.FilterDocuments;
import org.nuxeo.ecm.automation.core.operations.document.GetDocumentChild;
import org.nuxeo.ecm.automation.core.operations.document.GetDocumentChildren;
import org.nuxeo.ecm.automation.core.operations.document.GetDocumentParent;
import org.nuxeo.ecm.automation.core.operations.document.LockDocument;
import org.nuxeo.ecm.automation.core.operations.document.MoveDocument;
import org.nuxeo.ecm.automation.core.operations.document.MultiPublishDocument;
import org.nuxeo.ecm.automation.core.operations.document.PublishDocument;
import org.nuxeo.ecm.automation.core.operations.document.Query;
import org.nuxeo.ecm.automation.core.operations.document.ReloadDocument;
import org.nuxeo.ecm.automation.core.operations.document.RemoveDocumentACL;
import org.nuxeo.ecm.automation.core.operations.document.RemoveDocumentBlob;
import org.nuxeo.ecm.automation.core.operations.document.RemoveProperty;
import org.nuxeo.ecm.automation.core.operations.document.SaveDocument;
import org.nuxeo.ecm.automation.core.operations.document.SetDocumentACE;
import org.nuxeo.ecm.automation.core.operations.document.SetDocumentBlob;
import org.nuxeo.ecm.automation.core.operations.document.SetDocumentLifeCycle;
import org.nuxeo.ecm.automation.core.operations.document.SetDocumentProperty;
import org.nuxeo.ecm.automation.core.operations.document.UnlockDocument;
import org.nuxeo.ecm.automation.core.operations.document.UpdateDocument;
import org.nuxeo.ecm.automation.core.operations.execution.RunDocumentChain;
import org.nuxeo.ecm.automation.core.operations.execution.RunFileChain;
import org.nuxeo.ecm.automation.core.operations.execution.RunOperation;
import org.nuxeo.ecm.automation.core.operations.execution.RunOperationOnList;
import org.nuxeo.ecm.automation.core.operations.execution.SaveSession;
import org.nuxeo.ecm.automation.core.operations.login.LoginAs;
import org.nuxeo.ecm.automation.core.operations.login.Logout;
import org.nuxeo.ecm.automation.core.operations.stack.PopBlob;
import org.nuxeo.ecm.automation.core.operations.stack.PopBlobList;
import org.nuxeo.ecm.automation.core.operations.stack.PopDocument;
import org.nuxeo.ecm.automation.core.operations.stack.PopDocumentList;
import org.nuxeo.ecm.automation.core.operations.stack.PullBlob;
import org.nuxeo.ecm.automation.core.operations.stack.PullBlobList;
import org.nuxeo.ecm.automation.core.operations.stack.PullDocument;
import org.nuxeo.ecm.automation.core.operations.stack.PullDocumentList;
import org.nuxeo.ecm.automation.core.operations.stack.PushBlob;
import org.nuxeo.ecm.automation.core.operations.stack.PushBlobList;
import org.nuxeo.ecm.automation.core.operations.stack.PushDocument;
import org.nuxeo.ecm.automation.core.operations.stack.PushDocumentList;
import org.nuxeo.ecm.automation.core.rendering.operations.RenderDocument;
import org.nuxeo.ecm.automation.core.rendering.operations.RenderDocumentFeed;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class AutomationComponent
extends DefaultComponent {
    public static final String XP_OPERATIONS = "operations";
    public static final String XP_ADAPTERS = "adapters";
    public static final String XP_CHAINS = "chains";
    public static final String XP_EVENT_HANDLERS = "event-handlers";
    protected AutomationService service;
    protected EventHandlerRegistry handlers;

    public void activate(ComponentContext context) throws Exception {
        this.service = new OperationServiceImpl();
        this.service.putOperation(FetchContextDocument.class);
        this.service.putOperation(FetchContextBlob.class);
        this.service.putOperation(SetVar.class);
        this.service.putOperation(PushDocument.class);
        this.service.putOperation(PushDocumentList.class);
        this.service.putOperation(PopDocument.class);
        this.service.putOperation(PopDocumentList.class);
        this.service.putOperation(SetInputAsVar.class);
        this.service.putOperation(RestoreDocumentInput.class);
        this.service.putOperation(RestoreDocumentsInput.class);
        this.service.putOperation(RestoreBlobInput.class);
        this.service.putOperation(RestoreBlobsInput.class);
        this.service.putOperation(RunScript.class);
        this.service.putOperation(RunOperation.class);
        this.service.putOperation(RunOperationOnList.class);
        this.service.putOperation(RunDocumentChain.class);
        this.service.putOperation(RunFileChain.class);
        this.service.putOperation(CopyDocument.class);
        this.service.putOperation(CreateDocument.class);
        this.service.putOperation(CreateVersion.class);
        this.service.putOperation(CheckInDocument.class);
        this.service.putOperation(CheckOutDocument.class);
        this.service.putOperation(DeleteDocument.class);
        this.service.putOperation(FetchDocument.class);
        this.service.putOperation(LockDocument.class);
        this.service.putOperation(Query.class);
        this.service.putOperation(FetchByProperty.class);
        this.service.putOperation(FilterDocuments.class);
        this.service.putOperation(UnlockDocument.class);
        this.service.putOperation(GetDocumentChildren.class);
        this.service.putOperation(GetDocumentChild.class);
        this.service.putOperation(GetDocumentParent.class);
        this.service.putOperation(MoveDocument.class);
        this.service.putOperation(ReloadDocument.class);
        this.service.putOperation(SaveDocument.class);
        this.service.putOperation(SaveSession.class);
        this.service.putOperation(SetDocumentLifeCycle.class);
        this.service.putOperation(SetDocumentACE.class);
        this.service.putOperation(RemoveDocumentACL.class);
        this.service.putOperation(SetDocumentProperty.class);
        this.service.putOperation(RemoveProperty.class);
        this.service.putOperation(UpdateDocument.class);
        this.service.putOperation(PublishDocument.class);
        this.service.putOperation(MultiPublishDocument.class);
        this.service.putOperation(GetDocumentBlob.class);
        this.service.putOperation(GetDocumentBlobs.class);
        this.service.putOperation(SetDocumentBlob.class);
        this.service.putOperation(PostBlob.class);
        this.service.putOperation(BlobToPDF.class);
        this.service.putOperation(BlobToFile.class);
        this.service.putOperation(CreateBlob.class);
        this.service.putOperation(CreateZip.class);
        this.service.putOperation(AttachBlob.class);
        this.service.putOperation(SetBlobFileName.class);
        this.service.putOperation(RemoveDocumentBlob.class);
        this.service.putOperation(PushBlob.class);
        this.service.putOperation(PushBlobList.class);
        this.service.putOperation(PopBlob.class);
        this.service.putOperation(PopBlobList.class);
        this.service.putOperation(PullDocument.class);
        this.service.putOperation(PullDocumentList.class);
        this.service.putOperation(PullBlob.class);
        this.service.putOperation(PullBlobList.class);
        this.service.putOperation(FireEvent.class);
        this.service.putOperation(RunInputScript.class);
        this.service.putOperation(RenderDocument.class);
        this.service.putOperation(RenderDocumentFeed.class);
        this.service.putOperation(LoginAs.class);
        this.service.putOperation(Logout.class);
        this.handlers = new EventHandlerRegistry(this.service);
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.service = null;
        this.handlers = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_OPERATIONS.equals(extensionPoint)) {
            OperationContribution opc = (OperationContribution)contribution;
            this.service.putOperation(opc.type, opc.replace);
        } else if (XP_CHAINS.equals(extensionPoint)) {
            OperationChainContribution occ = (OperationChainContribution)contribution;
            this.service.putOperationChain(occ.toOperationChain(contributor.getContext().getBundle()), occ.replace);
        } else if (XP_ADAPTERS.equals(extensionPoint)) {
            TypeAdapterContribution tac = (TypeAdapterContribution)contribution;
            this.service.putTypeAdapter(tac.accept, tac.produce, tac.clazz.newInstance());
        } else if (XP_EVENT_HANDLERS.equals(extensionPoint)) {
            EventHandler eh = (EventHandler)contribution;
            if (eh.isPostCommit()) {
                this.handlers.putPostCommitEventHandler(eh);
            } else {
                this.handlers.putEventHandler(eh);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_OPERATIONS.equals(extensionPoint)) {
            this.service.removeOperation(((OperationContribution)contribution).type);
        } else if (XP_CHAINS.equals(extensionPoint)) {
            OperationChainContribution occ = (OperationChainContribution)contribution;
            this.service.removeOperationChain(occ.id);
        } else if (XP_ADAPTERS.equals(extensionPoint)) {
            TypeAdapterContribution tac = (TypeAdapterContribution)contribution;
            this.service.removeTypeAdapter(tac.accept, tac.produce);
        } else if (XP_EVENT_HANDLERS.equals(extensionPoint)) {
            EventHandler eh = (EventHandler)contribution;
            if (eh.isPostCommit()) {
                this.handlers.removePostCommitEventHandler(eh);
            } else {
                this.handlers.removeEventHandler(eh);
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == AutomationService.class) {
            return adapter.cast(this.service);
        }
        if (adapter == EventHandlerRegistry.class) {
            return adapter.cast(this.handlers);
        }
        return null;
    }
}

