/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import java.text.NumberFormat;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.facet.VersioningDocument;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.runtime.api.Framework;

public class VersioningDocumentAdapter
implements VersioningDocument {
    public final DocumentModel doc;
    public final VersioningService service;

    public VersioningDocumentAdapter(DocumentModel doc) {
        try {
            this.service = (VersioningService)Framework.getService(VersioningService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.doc = doc;
    }

    public Long getMajorVersion() throws DocumentException {
        return this.getValidVersionNumber("uid:major_version");
    }

    public Long getMinorVersion() throws DocumentException {
        return this.getValidVersionNumber("uid:minor_version");
    }

    public String getVersionLabel() {
        return this.service.getVersionLabel(this.doc);
    }

    @Deprecated
    public void incrementMajor() throws DocumentException {
        long major = this.getValidVersionNumber("uid:major_version");
        this.setMajorVersion(major + 1L);
        this.setMinorVersion(0L);
    }

    @Deprecated
    public void incrementMinor() throws DocumentException {
        long minor = this.getValidVersionNumber("uid:minor_version");
        this.setMinorVersion(minor + 1L);
    }

    @Deprecated
    public void setMajorVersion(Long value) {
        try {
            this.doc.setPropertyValue("uid:major_version", (Serializable)value);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Deprecated
    public void setMinorVersion(Long value) {
        try {
            this.doc.setPropertyValue("uid:minor_version", (Serializable)value);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private long getValidVersionNumber(String propName) {
        Serializable propVal;
        try {
            propVal = this.doc.getPropertyValue(propName);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return propVal == null || !(propVal instanceof Long) ? 0L : (Long)propVal;
    }

    @Deprecated
    public void refetchDoc() throws DocumentException {
        try {
            this.doc.refresh();
        }
        catch (ClientException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    @Deprecated
    public void incrementVersions() {
    }

    @Deprecated
    public String getVersionAsString(int majorDigits, int minorDigits, char sep) throws DocumentException {
        StringBuilder buf = new StringBuilder();
        NumberFormat fmt = VersioningDocumentAdapter.getFmt(majorDigits);
        buf.append(fmt.format(this.getMajorVersion()));
        buf.append(sep);
        NumberFormat fmt2 = VersioningDocumentAdapter.getFmt(minorDigits);
        buf.append(fmt2.format(this.getMinorVersion()));
        return buf.toString();
    }

    private static NumberFormat getFmt(int digits) {
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setMaximumIntegerDigits(digits);
        fmt.setMinimumIntegerDigits(digits);
        fmt.setMaximumFractionDigits(0);
        return fmt;
    }
}

