/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.Annotation;
import com.google.caja.ancillary.jsdoc.BlockAnnotation;
import com.google.caja.ancillary.jsdoc.TextAnnotation;
import com.google.caja.lexer.FilePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Summarizer {
    private static final Pattern SENTENCE_END = Pattern.compile("\\S[.?](?=\\s)");

    private static int summaryLength(String text) {
        Matcher m = SENTENCE_END.matcher(text = text.replaceAll("\\b([iI]\\.e\\.|[Ee]\\.g\\.)\\s", "$1#"));
        if (!m.find()) {
            return text.length();
        }
        return m.end();
    }

    public static BlockAnnotation summarize(BlockAnnotation a) {
        int nWhole;
        List<? extends Annotation> children = a.children();
        int partialLength = 0;
        for (nWhole = 0; nWhole < children.size(); ++nWhole) {
            int summaryLength;
            Annotation child = children.get(nWhole);
            if (!(child instanceof TextAnnotation) || (summaryLength = Summarizer.summaryLength(child.getValue())) >= child.getValue().length()) continue;
            partialLength = summaryLength;
            break;
        }
        ArrayList<? extends Annotation> summaryChildren = new ArrayList<Annotation>(children.subList(0, nWhole));
        if (partialLength != 0) {
            TextAnnotation last = (TextAnnotation)children.get(nWhole);
            summaryChildren.add(last.slice(0, partialLength));
        }
        Annotation lastChild = (Annotation)summaryChildren.get(summaryChildren.size() - 1);
        return new BlockAnnotation(a.getValue(), summaryChildren, FilePosition.span(a.getFilePosition(), lastChild.getFilePosition()));
    }

    private Summarizer() {
    }
}

