/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.LabeledStmtWrapper;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.SimpleQuasiNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuleChain {
    private final List<Rule> rules = new ArrayList<Rule>();
    private final Map<Class<? extends ParseTreeNode>, List<Rule>> filtered = new HashMap<Class<? extends ParseTreeNode>, List<Rule>>();
    private static final Map<String, Class<? extends ParseTreeNode>> lowerBounds = Collections.synchronizedMap(new HashMap());

    public void add(Rule r) {
        this.rules.add(r);
        this.filtered.clear();
    }

    public List<Rule> applicableTo(ParseTreeNode node) {
        Class<? extends ParseTreeNode> nodeType = RuleChain.toNodeType(node.getClass());
        List<Rule> filteredRules = this.filtered.get(nodeType);
        if (filteredRules == null) {
            this.computeRulesFor(nodeType);
            filteredRules = this.filtered.get(nodeType);
        }
        return filteredRules;
    }

    public Iterable<Rule> getAllRules() {
        return Collections.unmodifiableList(this.rules);
    }

    private void computeRulesFor(Class<? extends ParseTreeNode> nodeType) {
        ArrayList<Rule> applicableRules = new ArrayList<Rule>();
        for (Rule rule : this.rules) {
            String pattern = rule.getRuleDescription().matches();
            Class<? extends ParseTreeNode> lowerBound = lowerBounds.get(pattern);
            if (lowerBound == null) {
                try {
                    QuasiNode p = QuasiBuilder.parseQuasiNode(pattern);
                    lowerBound = p instanceof SimpleQuasiNode ? RuleChain.toNodeType(((SimpleQuasiNode)p).getMatchedClass()) : ParseTreeNode.class;
                }
                catch (ParseException ex) {
                    lowerBound = ParseTreeNode.class;
                }
                lowerBounds.put(pattern, lowerBound);
            }
            if (!lowerBound.isAssignableFrom(nodeType)) continue;
            applicableRules.add(rule);
        }
        this.filtered.put(nodeType, Collections.unmodifiableList(applicableRules));
    }

    private static Class<? extends ParseTreeNode> toNodeType(Class<? extends ParseTreeNode> nodeClass) {
        if (nodeClass == FunctionDeclaration.class) {
            return FunctionConstructor.class;
        }
        if (nodeClass == Expression.class) {
            return ExpressionStmt.class;
        }
        if (nodeClass == Reference.class) {
            return Identifier.class;
        }
        if (nodeClass == LabeledStmtWrapper.class) {
            return LabeledStatement.class;
        }
        return nodeClass;
    }

    static {
        lowerBounds.put(null, ParseTreeNode.class);
    }
}

