/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyDecimal;
import org.apache.chemistry.opencmis.commons.data.PropertyHtml;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.PropertyUri;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingsObjectFactoryImpl
implements BindingsObjectFactory,
Serializable {
    private static final long serialVersionUID = 1L;

    public Ace createAccessControlEntry(String principal, List<String> permissions) {
        return new AccessControlEntryImpl(new AccessControlPrincipalDataImpl(principal), permissions);
    }

    public Acl createAccessControlList(List<Ace> aces) {
        return new AccessControlListImpl(aces);
    }

    public ContentStream createContentStream(String filename, BigInteger length, String mimetype, InputStream stream) {
        return new ContentStreamImpl(filename, length, mimetype, stream);
    }

    public Properties createPropertiesData(List<PropertyData<?>> properties) {
        return new PropertiesImpl(properties);
    }

    public <T> AbstractPropertyData<T> createPropertyData(PropertyDefinition<T> pd, Object value) {
        boolean single;
        String id = pd.getId();
        boolean bl = single = pd.getCardinality() == Cardinality.SINGLE;
        if (pd instanceof PropertyBooleanDefinition) {
            if (single) {
                return (AbstractPropertyData)this.createPropertyBooleanData(id, (Boolean)value);
            }
            return (AbstractPropertyData)this.createPropertyBooleanData(id, (List)value);
        }
        if (pd instanceof PropertyDateTimeDefinition) {
            if (single) {
                return (AbstractPropertyData)this.createPropertyDateTimeData(id, (GregorianCalendar)value);
            }
            return (AbstractPropertyData)this.createPropertyDateTimeData(id, (List)value);
        }
        if (pd instanceof PropertyDecimalDefinition) {
            if (single) {
                return (AbstractPropertyData)this.createPropertyDecimalData(id, (BigDecimal)value);
            }
            return (AbstractPropertyData)this.createPropertyDecimalData(id, (List)value);
        }
        if (pd instanceof PropertyHtmlDefinition) {
            if (single) {
                return (AbstractPropertyData)this.createPropertyHtmlData(id, (String)value);
            }
            return (AbstractPropertyData)this.createPropertyHtmlData(id, (List)value);
        }
        if (pd instanceof PropertyIdDefinition) {
            if (single) {
                return (AbstractPropertyData)this.createPropertyIdData(id, (String)value);
            }
            return (AbstractPropertyData)this.createPropertyIdData(id, (List)value);
        }
        if (pd instanceof PropertyIntegerDefinition) {
            if (single) {
                return (AbstractPropertyData)this.createPropertyIntegerData(id, (BigInteger)value);
            }
            return (AbstractPropertyData)this.createPropertyIntegerData(id, (List)value);
        }
        if (pd instanceof PropertyStringDefinition) {
            if (single) {
                return (AbstractPropertyData)this.createPropertyStringData(id, (String)value);
            }
            return (AbstractPropertyData)this.createPropertyStringData(id, (List)value);
        }
        if (pd instanceof PropertyUriDefinition) {
            if (single) {
                return (AbstractPropertyData)this.createPropertyUriData(id, (String)value);
            }
            return (AbstractPropertyData)this.createPropertyUriData(id, (List)value);
        }
        throw new CmisRuntimeException("Unknown property definition: " + pd);
    }

    public PropertyBoolean createPropertyBooleanData(String id, List<Boolean> values) {
        return new PropertyBooleanImpl(id, values);
    }

    public PropertyBoolean createPropertyBooleanData(String id, Boolean value) {
        return new PropertyBooleanImpl(id, value);
    }

    public PropertyDateTime createPropertyDateTimeData(String id, List<GregorianCalendar> values) {
        return new PropertyDateTimeImpl(id, values);
    }

    public PropertyDateTime createPropertyDateTimeData(String id, GregorianCalendar value) {
        return new PropertyDateTimeImpl(id, value);
    }

    public PropertyDecimal createPropertyDecimalData(String id, List<BigDecimal> values) {
        return new PropertyDecimalImpl(id, values);
    }

    public PropertyDecimal createPropertyDecimalData(String id, BigDecimal value) {
        return new PropertyDecimalImpl(id, value);
    }

    public PropertyHtml createPropertyHtmlData(String id, List<String> values) {
        return new PropertyHtmlImpl(id, values);
    }

    public PropertyHtml createPropertyHtmlData(String id, String value) {
        return new PropertyHtmlImpl(id, value);
    }

    public PropertyId createPropertyIdData(String id, List<String> values) {
        return new PropertyIdImpl(id, values);
    }

    public PropertyId createPropertyIdData(String id, String value) {
        return new PropertyIdImpl(id, value);
    }

    public PropertyInteger createPropertyIntegerData(String id, List<BigInteger> values) {
        return new PropertyIntegerImpl(id, values);
    }

    public PropertyInteger createPropertyIntegerData(String id, BigInteger value) {
        return new PropertyIntegerImpl(id, value);
    }

    public PropertyString createPropertyStringData(String id, List<String> values) {
        return new PropertyStringImpl(id, values);
    }

    public PropertyString createPropertyStringData(String id, String value) {
        return new PropertyStringImpl(id, value);
    }

    public PropertyUri createPropertyUriData(String id, List<String> values) {
        return new PropertyUriImpl(id, values);
    }

    public PropertyUri createPropertyUriData(String id, String value) {
        return new PropertyUriImpl(id, value);
    }
}

