/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.oauth;

import com.google.inject.Singleton;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.nuxeo.ecm.platform.oauth.providers.NuxeoOAuthServiceProvider;
import org.nuxeo.ecm.platform.oauth.providers.OAuthServiceProviderRegistry;
import org.nuxeo.ecm.platform.oauth.tokens.NuxeoOAuthToken;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthTokenStore;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.runtime.api.Framework;

@Singleton
public class NXOAuthStore
extends BasicOAuthStore {
    protected static final Log log = LogFactory.getLog(NXOAuthStore.class);
    protected String nxDefaultCallBackUrl;
    protected BasicOAuthStoreConsumerKeyAndSecret nxDefaultKey;

    public void setDefaultKey(BasicOAuthStoreConsumerKeyAndSecret defaultKey) {
        this.nxDefaultKey = defaultKey;
        super.setDefaultKey(defaultKey);
    }

    public void setDefaultCallbackUrl(String defaultCallbackUrl) {
        this.nxDefaultCallBackUrl = defaultCallbackUrl;
        super.setDefaultCallbackUrl(defaultCallbackUrl);
    }

    public OAuthStore.ConsumerInfo getConsumerKeyAndSecret(SecurityToken securityToken, String serviceName, OAuthServiceProvider provider) throws GadgetException {
        OAuthServiceProviderRegistry spr = (OAuthServiceProviderRegistry)Framework.getLocalService(OAuthServiceProviderRegistry.class);
        OpenSocialService os = (OpenSocialService)Framework.getLocalService(OpenSocialService.class);
        NuxeoOAuthServiceProvider sp = spr.getProvider(securityToken.getAppUrl(), serviceName);
        if (sp == null) {
            return super.getConsumerKeyAndSecret(securityToken, serviceName, provider);
        }
        String consumerKey = sp.getConsumerKey();
        String secret = sp.getConsumerSecret();
        BasicOAuthStoreConsumerKeyAndSecret.KeyType kt = BasicOAuthStoreConsumerKeyAndSecret.KeyType.HMAC_SYMMETRIC;
        String name = serviceName;
        if (secret == null || "".equals(secret.trim())) {
            secret = this.nxDefaultKey.getConsumerSecret();
            kt = BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE;
            name = this.nxDefaultKey.getKeyName();
        }
        String callBack = this.nxDefaultCallBackUrl;
        OAuthConsumer consumer = new OAuthConsumer(callBack, consumerKey, secret, provider);
        if (kt == BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE) {
            consumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
            consumer.setProperty("RSA-SHA1.PrivateKey", (Object)secret);
        } else {
            consumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
        }
        return new OAuthStore.ConsumerInfo(consumer, serviceName, callBack);
    }

    public OAuthStore.TokenInfo getTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) {
        OAuthTokenStore nxStore = (OAuthTokenStore)Framework.getLocalService(OAuthTokenStore.class);
        String appId = securityToken.getAppId();
        String owner = securityToken.getOwnerId();
        try {
            NuxeoOAuthToken nxToken = nxStore.getClientAccessToken(appId, owner);
            if (nxToken != null) {
                String accessToken = nxToken.getToken();
                String tokenSecret = nxToken.getTokenSecret();
                String sessionHandle = null;
                long tokenExpireMillis = 0L;
                OAuthStore.TokenInfo tokenInfo = new OAuthStore.TokenInfo(accessToken, tokenSecret, sessionHandle, tokenExpireMillis);
                return tokenInfo;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while try to get Client Token from store", (Throwable)e);
        }
        OAuthStore.TokenInfo tokenInfo = super.getTokenInfo(securityToken, consumerInfo, serviceName, tokenName);
        return tokenInfo;
    }

    public void setTokenInfo(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName, OAuthStore.TokenInfo tokenInfo) {
        OAuthTokenStore nxStore = (OAuthTokenStore)Framework.getLocalService(OAuthTokenStore.class);
        String consumerKey = consumerInfo.getConsumer().consumerKey;
        String callBack = consumerInfo.getConsumer().callbackURL;
        String appId = securityToken.getAppId();
        String owner = securityToken.getOwnerId();
        String token = tokenInfo.getAccessToken();
        String tokenSecret = tokenInfo.getTokenSecret();
        nxStore.storeClientAccessToken(consumerKey, callBack, token, tokenSecret, appId, owner);
        super.setTokenInfo(securityToken, consumerInfo, serviceName, tokenName, tokenInfo);
    }

    public void removeToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, String serviceName, String tokenName) {
        OAuthTokenStore nxStore = (OAuthTokenStore)Framework.getLocalService(OAuthTokenStore.class);
        String appId = securityToken.getAppId();
        String owner = securityToken.getOwnerId();
        super.removeToken(securityToken, consumerInfo, serviceName, tokenName);
    }
}

