/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AllowableActionsDocument;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntryParser;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public final class ObjectService {
    private static final int BUFFER_SIZE = 65536;

    private ObjectService() {
    }

    public static void create(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String folderId = HttpUtils.getStringParameter(request, "id");
        String sourceFolderId = HttpUtils.getStringParameter(request, "sourceFolderId");
        VersioningState versioningState = HttpUtils.getEnumParameter(request, "versioningState", VersioningState.class);
        AtomEntryParser parser = new AtomEntryParser();
        parser.setIgnoreAtomContentSrc(true);
        parser.parse((InputStream)request.getInputStream());
        String objectId = parser.getId();
        String newObjectId = null;
        if (objectId == null) {
            newObjectId = service.create(repositoryId, parser.getProperties(), folderId, parser.getContentStream(), versioningState, parser.getPolicyIds(), null);
        } else if (sourceFolderId == null || sourceFolderId.trim().length() == 0) {
            service.addObjectToFolder(repositoryId, objectId, folderId, null, null);
            newObjectId = objectId;
        } else {
            Holder objectIdHolder = new Holder((Object)objectId);
            service.moveObject(repositoryId, objectIdHolder, folderId, sourceFolderId, null);
            newObjectId = (String)objectIdHolder.getValue();
        }
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, newObjectId);
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        ObjectData object = objectInfo.getObject();
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        response.setStatus(201);
        response.setContentType("application/atom+xml;type=entry");
        response.setHeader("Location", AtomPubUtils.compileUrl(baseUrl, "entry", newObjectId));
        AtomEntry entry = new AtomEntry();
        entry.startDocument((OutputStream)response.getOutputStream());
        AtomPubUtils.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true);
        entry.endDocument();
    }

    public static void createRelationship(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AtomEntryParser parser = new AtomEntryParser((InputStream)request.getInputStream());
        String newObjectId = service.createRelationship(repositoryId, parser.getProperties(), parser.getPolicyIds(), null, null, null);
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, newObjectId);
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        ObjectData object = objectInfo.getObject();
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        response.setStatus(201);
        response.setContentType("application/atom+xml;type=entry");
        response.setHeader("Location", AtomPubUtils.compileUrl(baseUrl, "entry", newObjectId));
        AtomEntry entry = new AtomEntry();
        entry.startDocument((OutputStream)response.getOutputStream());
        AtomPubUtils.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true);
        entry.endDocument();
    }

    public static void deleteObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) {
        String objectId = HttpUtils.getStringParameter(request, "id");
        Boolean allVersions = HttpUtils.getBooleanParameter(request, "allVersions");
        service.deleteObjectOrCancelCheckOut(repositoryId, objectId, allVersions, null);
        response.setStatus(204);
    }

    public static void deleteContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) {
        String objectId = HttpUtils.getStringParameter(request, "id");
        String changeToken = HttpUtils.getStringParameter(request, "changeToken");
        service.deleteContentStream(repositoryId, new Holder((Object)objectId), changeToken == null ? null : new Holder((Object)changeToken), null);
        response.setStatus(204);
    }

    public static void setContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String contentDisposition;
        String objectId = HttpUtils.getStringParameter(request, "id");
        String changeToken = HttpUtils.getStringParameter(request, "changeToken");
        Boolean overwriteFlag = HttpUtils.getBooleanParameter(request, "overwriteFlag");
        ContentStreamImpl contentStream = new ContentStreamImpl();
        contentStream.setStream((InputStream)request.getInputStream());
        contentStream.setMimeType(request.getHeader("Content-Type"));
        String lengthStr = request.getHeader("Content-Length");
        if (lengthStr != null) {
            try {
                contentStream.setLength(new BigInteger(lengthStr));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((contentDisposition = request.getHeader("Content-Disposition")) != null) {
            contentStream.setFileName(MimeHelper.decodeContentDispositionFilename((String)contentDisposition));
        }
        Holder objectIdHolder = new Holder((Object)objectId);
        service.setContentStream(repositoryId, objectIdHolder, overwriteFlag, changeToken == null ? null : new Holder((Object)changeToken), (ContentStream)contentStream, null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        String location = AtomPubUtils.compileUrl(AtomPubUtils.compileBaseUrl(request, repositoryId), "content", newObjectId);
        response.setStatus(201);
        response.setHeader("Content-Location", location);
        response.setHeader("Location", location);
    }

    public static void deleteTree(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean continueOnFailure;
        UnfileObject unfileObjects;
        Boolean allVersions;
        String folderId = HttpUtils.getStringParameter(request, "id");
        FailedToDeleteData ftd = service.deleteTree(repositoryId, folderId, allVersions = HttpUtils.getBooleanParameter(request, "allVersions"), unfileObjects = HttpUtils.getEnumParameter(request, "unfileObjects", UnfileObject.class), continueOnFailure = HttpUtils.getBooleanParameter(request, "continueOnFailure"), null);
        if (ftd != null && ftd.getIds() != null && ftd.getIds().size() > 0) {
            response.setStatus(500);
            response.setContentType("text/plain");
            PrintWriter pw = response.getWriter();
            pw.println("Failed to delete the following objects:");
            for (String id : ftd.getIds()) {
                pw.println(id);
            }
            pw.flush();
            return;
        }
        response.setStatus(204);
    }

    public static void getObject(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = HttpUtils.getStringParameter(request, "id");
        ReturnVersion returnVersion = HttpUtils.getEnumParameter(request, "returnVersion", ReturnVersion.class);
        String filter = HttpUtils.getStringParameter(request, "filter");
        Boolean includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions");
        IncludeRelationships includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
        String renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter");
        Boolean includePolicyIds = HttpUtils.getBooleanParameter(request, "includePolicyIds");
        Boolean includeAcl = HttpUtils.getBooleanParameter(request, "includeACL");
        ObjectData object = null;
        object = returnVersion == ReturnVersion.LATEST || returnVersion == ReturnVersion.LASTESTMAJOR ? service.getObjectOfLatestVersion(repositoryId, objectId, null, Boolean.valueOf(returnVersion == ReturnVersion.LASTESTMAJOR), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null) : service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=entry");
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        AtomEntry entry = new AtomEntry();
        entry.startDocument((OutputStream)response.getOutputStream());
        AtomPubUtils.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true);
        entry.endDocument();
    }

    public static void getObjectByPath(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean includeAcl;
        Boolean includePolicyIds;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String filter;
        String path = HttpUtils.getStringParameter(request, "path");
        ObjectData object = service.getObjectByPath(repositoryId, path, filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includePolicyIds = HttpUtils.getBooleanParameter(request, "includePolicyIds"), includeAcl = HttpUtils.getBooleanParameter(request, "includeACL"), null);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, object.getId());
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=entry");
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        AtomEntry entry = new AtomEntry();
        entry.startDocument((OutputStream)response.getOutputStream());
        AtomPubUtils.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true);
        entry.endDocument();
    }

    public static void getAllowableActions(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = HttpUtils.getStringParameter(request, "id");
        AllowableActions allowableActions = service.getAllowableActions(repositoryId, objectId, null);
        if (allowableActions == null) {
            throw new CmisRuntimeException("Allowable Actions is null!");
        }
        response.setStatus(200);
        response.setContentType("application/cmisallowableactions+xml");
        AllowableActionsDocument allowableActionsDocument = new AllowableActionsDocument();
        allowableActionsDocument.writeAllowableActions(allowableActions, (OutputStream)response.getOutputStream());
    }

    public static void getContentStream(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int b;
        BigInteger length;
        BigInteger offset;
        String streamId;
        String objectId = HttpUtils.getStringParameter(request, "id");
        ContentStream content = service.getContentStream(repositoryId, objectId, streamId = HttpUtils.getStringParameter(request, "streamId"), offset = context.getOffset(), length = context.getLength(), null);
        if (content == null || content.getStream() == null) {
            throw new CmisRuntimeException("Content stream is null!");
        }
        String contentType = content.getMimeType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        if (offset == null && length == null) {
            response.setStatus(200);
        } else {
            response.setStatus(206);
        }
        response.setContentType(contentType);
        BufferedInputStream in = new BufferedInputStream(content.getStream(), 65536);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        byte[] buffer = new byte[65536];
        while ((b = ((InputStream)in).read(buffer)) > -1) {
            ((OutputStream)out).write(buffer, 0, b);
        }
        ((InputStream)in).close();
        ((OutputStream)out).flush();
    }

    public static void updateProperties(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = HttpUtils.getStringParameter(request, "id");
        Boolean checkin = HttpUtils.getBooleanParameter(request, "checkin");
        String checkinComment = HttpUtils.getStringParameter(request, "checkinComment");
        Boolean major = HttpUtils.getBooleanParameter(request, "major");
        AtomEntryParser parser = new AtomEntryParser((InputStream)request.getInputStream());
        Holder objectIdHolder = new Holder((Object)objectId);
        if (checkin != null && checkin.booleanValue()) {
            service.checkIn(repositoryId, objectIdHolder, major, parser.getProperties(), parser.getContentStream(), checkinComment, parser.getPolicyIds(), null, null, null);
        } else {
            String changeToken = ObjectService.extractChangeToken(parser.getProperties());
            service.updateProperties(repositoryId, objectIdHolder, changeToken == null ? null : new Holder((Object)changeToken), parser.getProperties(), null);
        }
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, (String)objectIdHolder.getValue());
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        ObjectData object = objectInfo.getObject();
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        String location = AtomPubUtils.compileUrl(baseUrl, "entry", (String)objectIdHolder.getValue());
        response.setStatus(201);
        response.setContentType("application/atom+xml;type=entry");
        response.setHeader("Content-Location", location);
        response.setHeader("Location", location);
        AtomEntry entry = new AtomEntry();
        entry.startDocument((OutputStream)response.getOutputStream());
        AtomPubUtils.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true);
        entry.endDocument();
    }

    private static String extractChangeToken(Properties properties) {
        if (properties == null) {
            return null;
        }
        Map propertiesMap = properties.getProperties();
        if (propertiesMap == null) {
            return null;
        }
        PropertyData changeLogProperty = (PropertyData)propertiesMap.get("cmis:changeToken");
        if (!(changeLogProperty instanceof PropertyString)) {
            return null;
        }
        return (String)((PropertyString)changeLogProperty).getFirstValue();
    }
}

