/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAttributeTypeRegistry
implements AttributeTypeRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultAttributeTypeRegistry.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private final Map<String, AttributeType> byOid = new HashMap<String, AttributeType>();
    private final Map<String, Set<AttributeType>> oidToDescendantSet = new HashMap<String, Set<AttributeType>>();
    private final OidRegistry oidRegistry;
    private transient Map<String, OidNormalizer> mapping;

    public DefaultAttributeTypeRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    @Override
    public void register(AttributeType attributeType) throws NamingException {
        if (this.byOid.containsKey(attributeType.getOid())) {
            NamingException e = new NamingException("attributeType w/ OID " + attributeType.getOid() + " has already been registered!");
            throw e;
        }
        String[] names = attributeType.getNames();
        for (int ii = 0; ii < names.length; ++ii) {
            this.oidRegistry.register(names[ii], attributeType.getOid());
        }
        this.oidRegistry.register(attributeType.getOid(), attributeType.getOid());
        this.registerDescendants(attributeType);
        this.byOid.put(attributeType.getOid(), attributeType);
        if (IS_DEBUG) {
            log.debug("registed attributeType: " + attributeType);
        }
    }

    public void registerDescendants(AttributeType attributeType) throws NamingException {
        this.oidToDescendantSet.put(attributeType.getOid(), new HashSet(5));
        this.onRegisterAddToAncestorDescendants(attributeType, attributeType.getSuperior());
    }

    protected void onRegisterAddToAncestorDescendants(AttributeType newType, AttributeType ancestor) throws NamingException {
        if (ancestor == null) {
            return;
        }
        if (ancestor.getName() != null && ancestor.getName().equals("top")) {
            return;
        }
        Set<AttributeType> descendants = this.oidToDescendantSet.get(ancestor.getOid());
        if (descendants == null) {
            descendants = new HashSet<AttributeType>(5);
            this.oidToDescendantSet.put(ancestor.getOid(), descendants);
        }
        descendants.add(newType);
        this.onRegisterAddToAncestorDescendants(newType, ancestor.getSuperior());
    }

    @Override
    public AttributeType lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NamingException e = new NamingException("attributeType w/ OID " + id + " not registered!");
            throw e;
        }
        AttributeType attributeType = this.byOid.get(id);
        if (IS_DEBUG) {
            log.debug("lookup with id" + id + "' of attributeType: " + attributeType);
        }
        return attributeType;
    }

    @Override
    public boolean hasAttributeType(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        AttributeType at = this.byOid.get(id = this.oidRegistry.getOid(id));
        if (at != null) {
            return at.getSchema();
        }
        throw new NamingException("OID " + id + " not found in oid to " + "AttributeType map!");
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }

    @Override
    public Map<String, OidNormalizer> getNormalizerMapping() throws NamingException {
        if (this.mapping == null) {
            this.mapping = new HashMap<String, OidNormalizer>(this.byOid.size() << 1);
            for (AttributeType type : this.byOid.values()) {
                MatchingRule matchingRule = type.getEquality();
                OidNormalizer oidNormalizer = null;
                if (matchingRule == null) {
                    log.debug("Attribute " + type.getName() + " does not have normalizer : using NoopNormalizer");
                    oidNormalizer = new OidNormalizer(type.getOid(), (Normalizer)new NoOpNormalizer());
                } else {
                    oidNormalizer = new OidNormalizer(type.getOid(), matchingRule.getNormalizer());
                }
                this.mapping.put(type.getOid(), oidNormalizer);
                String[] aliases = type.getNames();
                for (int jj = 0; jj < aliases.length; ++jj) {
                    this.mapping.put(aliases[jj], oidNormalizer);
                    this.mapping.put(aliases[jj].toLowerCase(), oidNormalizer);
                }
            }
        }
        return Collections.unmodifiableMap(this.mapping);
    }

    @Override
    public Iterator descendants(String ancestorId) throws NamingException {
        String oid = this.oidRegistry.getOid(ancestorId);
        Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
        if (descendants == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return descendants.iterator();
    }

    @Override
    public boolean hasDescendants(String ancestorId) throws NamingException {
        String oid = this.oidRegistry.getOid(ancestorId);
        Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
        if (descendants == null) {
            return false;
        }
        return !descendants.isEmpty();
    }

    @Override
    public Iterator<AttributeType> iterator() {
        return this.byOid.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!Character.isDigit(numericOid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        this.byOid.remove(numericOid);
        this.oidToDescendantSet.remove(numericOid);
    }
}

