/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.notification;

import java.net.URL;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;

public class MailTemplateHelper {
    private MailTemplateHelper() {
    }

    public static String getDocumentUrl(DocumentModel doc, String viewId) throws Exception {
        if (viewId == null) {
            viewId = "view_documents";
        }
        DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc);
        docView.setViewId(viewId);
        DocumentViewCodecManager codecMgr = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        NotificationService notifMgr = NotificationServiceHelper.getNotificationService();
        if (codecMgr == null) {
            throw new RuntimeException("Service 'DocumentViewCodecManager' not available");
        }
        if (notifMgr == null) {
            throw new RuntimeException("Service 'NotificationService' not available");
        }
        return codecMgr.getUrlFromDocumentView((DocumentView)docView, true, notifMgr.getServerUrlPrefix());
    }

    public static URL getTemplate(String name) {
        return NotificationService.getTemplateURL((String)name);
    }
}

