/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStream;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSTHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final boolean isMultipart;
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private String filename;
    private String contentType;
    private BigInteger size;
    private InputStream stream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POSTHttpServletRequestWrapper(HttpServletRequest request, File tempDir, int memoryThreshold) throws Exception {
        super(request);
        this.parseFormData(request.getQueryString());
        this.isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (this.isMultipart) {
            String contentTypeControl;
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String name = item.getFieldName();
                BufferedInputStream itemStream = new BufferedInputStream(item.openStream());
                if (item.isFormField()) {
                    InputStreamReader reader = new InputStreamReader((InputStream)itemStream, "UTF-8");
                    try {
                        StringBuilder sb = new StringBuilder();
                        char[] buffer = new char[65536];
                        int b = 0;
                        while ((b = reader.read(buffer)) > -1) {
                            sb.append(buffer, 0, b);
                        }
                        this.addParameter(name, sb.toString());
                        continue;
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                        continue;
                    }
                }
                this.filename = item.getName();
                this.contentType = item.getContentType() == null ? "application/octet-stream" : item.getContentType();
                ThresholdOutputStream os = new ThresholdOutputStream(tempDir, memoryThreshold);
                try {
                    byte[] buffer = new byte[65536];
                    int b = 0;
                    while ((b = ((InputStream)itemStream).read(buffer)) > -1) {
                        os.write(buffer, 0, b);
                    }
                    os.close();
                    this.size = BigInteger.valueOf(os.getSize());
                    this.stream = os.getInputStream();
                }
                catch (Exception e) {
                    os.destroy();
                    throw e;
                }
                finally {
                    try {
                        ((InputStream)itemStream).close();
                    }
                    catch (Exception e) {}
                }
            }
            String filenameControl = HttpUtils.getStringParameter((HttpServletRequest)this, "filename");
            if (filenameControl != null && filenameControl.trim().length() > 0) {
                this.filename = filenameControl;
            }
            if ((contentTypeControl = HttpUtils.getStringParameter((HttpServletRequest)this, "contenttype")) != null && contentTypeControl.trim().length() > 0) {
                this.contentType = contentTypeControl;
            }
        } else {
            StringBuilder sb = new StringBuilder();
            InputStreamReader sr = new InputStreamReader((InputStream)request.getInputStream(), "UTF-8");
            char[] buffer = new char[4096];
            int c = 0;
            while ((c = sr.read(buffer)) > -1) {
                sb.append(buffer, 0, c);
            }
            this.parseFormData(sb.toString());
        }
    }

    private void parseFormData(String data) throws Exception {
        String[] nameValuePairs;
        if (data == null || data.length() < 3) {
            return;
        }
        for (String nameValuePair : nameValuePairs = data.split("&")) {
            int x = nameValuePair.indexOf(61);
            if (x <= 0) continue;
            String name = URLDecoder.decode(nameValuePair.substring(0, x), "UTF-8");
            String value = x == nameValuePair.length() - 1 ? "" : URLDecoder.decode(nameValuePair.substring(x + 1), "UTF-8");
            this.addParameter(name, value);
        }
    }

    private void addParameter(String name, String value) {
        String[] values = this.parameters.get(name);
        if (values == null) {
            this.parameters.put(name, new String[]{value});
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            this.parameters.put(name, newValues);
        }
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public InputStream getStream() {
        return this.stream;
    }
}

