/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.util.Arrays;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class AttributeUtils {
    public static Attribute removeAttribute(AttributeType type, Attributes entry) throws NamingException {
        Attribute attr = entry.get(type.getOid());
        if (attr == null) {
            String[] aliases = type.getNames();
            for (int ii = 0; ii < aliases.length; ++ii) {
                attr = entry.get(aliases[ii]);
                if (attr == null) continue;
                return entry.remove(attr.getID());
            }
        }
        if (attr == null) {
            return null;
        }
        return entry.remove(attr.getID());
    }

    public static final boolean equals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 instanceof byte[]) {
            if (value2 instanceof byte[]) {
                return Arrays.equals((byte[])value1, (byte[])value2);
            }
            return false;
        }
        return value1.equals(value2);
    }

    public static final Object cloneValue(Object value) {
        Object newValue = null;
        newValue = value instanceof byte[] ? ((byte[])value).clone() : value;
        return newValue;
    }

    public static final Attribute toAttributeImpl(Attribute attribute) {
        if (attribute instanceof AttributeImpl) {
            return attribute;
        }
        AttributeImpl newAttribute = new AttributeImpl(attribute.getID());
        try {
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                newAttribute.add(AttributeUtils.cloneValue(values.next()));
            }
            return newAttribute;
        }
        catch (NamingException ne) {
            return newAttribute;
        }
    }

    public static final Attributes toAttributesImpl(Attributes attributes) {
        if (attributes instanceof AttributesImpl) {
            return attributes;
        }
        AttributesImpl newAttributes = new AttributesImpl(attributes.isCaseIgnored());
        try {
            NamingEnumeration<? extends Attribute> values = attributes.getAll();
            while (values.hasMoreElements()) {
                Attribute attribute = values.next();
                newAttributes.put(AttributeUtils.toAttributeImpl(attribute));
            }
            return newAttributes;
        }
        catch (NamingException ne) {
            return newAttributes;
        }
    }

    public static final Attribute getAttribute(Attributes attrs, AttributeType type) {
        Attribute attr = attrs.get(type.getOid());
        if (attr != null) {
            return attr;
        }
        if (type.getNames().length == 1 && (attr = attrs.get(type.getNames()[0])) != null) {
            return attr;
        }
        for (String alias : type.getNames()) {
            attr = attrs.get(alias);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    public static final ModificationItemImpl getModificationItem(ModificationItemImpl[] mods, AttributeType type) {
        int jj;
        if (type.getNames().length == 1) {
            for (jj = 0; jj < mods.length; ++jj) {
                if (!mods[jj].getAttribute().getID().equalsIgnoreCase(type.getNames()[0])) continue;
                return mods[jj];
            }
        }
        for (jj = 0; jj < mods.length; ++jj) {
            if (!mods[jj].getAttribute().getID().equals(type.getOid())) continue;
            return mods[jj];
        }
        for (int ii = 0; ii < type.getNames().length; ++ii) {
            for (int jj2 = 0; jj2 < mods.length; ++jj2) {
                if (!mods[jj2].getAttribute().getID().equalsIgnoreCase(type.getNames()[ii])) continue;
                return mods[jj2];
            }
        }
        return null;
    }

    public static final Attribute getAttribute(ModificationItemImpl[] mods, AttributeType type) {
        ModificationItemImpl mod = AttributeUtils.getModificationItem(mods, type);
        if (mod != null) {
            return mod.getAttribute();
        }
        return null;
    }

    public static final boolean containsValue(Attribute attr, Object compared, AttributeType type) throws NamingException {
        if (attr.contains(compared)) {
            return true;
        }
        Normalizer normalizer = type.getEquality().getNormalizer();
        if (type.getSyntax().isHumanReadable()) {
            String comparedStr = (String)normalizer.normalize(compared);
            NamingEnumeration<?> values = attr.getAll();
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (!comparedStr.equals(normalizer.normalize(value))) continue;
                return true;
            }
        } else {
            byte[] comparedBytes = (byte[])compared;
            NamingEnumeration<?> values = attr.getAll();
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (!ArrayUtils.isEquals(comparedBytes, value)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean containsValueCaseIgnore(Attribute attr, Object value) {
        if (attr.contains(value)) {
            return true;
        }
        try {
            if (value instanceof String) {
                String strVal = (String)value;
                NamingEnumeration<?> attrVals = attr.getAll();
                while (attrVals.hasMoreElements()) {
                    Object attrVal = attrVals.nextElement();
                    if (!(attrVal instanceof String) || !strVal.equalsIgnoreCase((String)attrVal)) continue;
                    return true;
                }
            } else {
                byte[] valueBytes = (byte[])value;
                NamingEnumeration<?> attrVals = attr.getAll();
                while (attrVals.hasMoreElements()) {
                    Object attrVal = attrVals.nextElement();
                    if (!(attrVal instanceof byte[]) || !Arrays.equals((byte[])attrVal, valueBytes)) continue;
                    return true;
                }
            }
        }
        catch (NamingException ne) {
            return false;
        }
        return false;
    }

    public static boolean containsAnyValues(Attribute attr, Object[] compared, AttributeType type) throws NamingException {
        for (int ii = 0; ii < compared.length; ++ii) {
            if (!attr.contains(compared)) continue;
            return true;
        }
        Normalizer normalizer = type.getEquality().getNormalizer();
        if (type.getSyntax().isHumanReadable()) {
            for (int jj = 0; jj < compared.length; ++jj) {
                String comparedStr = (String)normalizer.normalize(compared[jj]);
                for (int ii = attr.size(); ii >= 0; --ii) {
                    String value = (String)attr.get(ii);
                    if (!comparedStr.equals(normalizer.normalize(value))) continue;
                    return true;
                }
            }
        } else {
            for (int jj = 0; jj < compared.length; ++jj) {
                byte[] comparedBytes = (byte[])compared[jj];
                for (int ii = attr.size(); ii >= 0; --ii) {
                    if (!ArrayUtils.isEquals(comparedBytes, attr.get(ii))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Attribute getDifference(Attribute attr0, Attribute attr1) throws NamingException {
        int ii;
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException("Cannot figure out attribute ID if both args are null");
        }
        if (attr0 == null) {
            return new AttributeImpl(attr1.getID());
        }
        if (attr1 == null) {
            return (Attribute)attr0.clone();
        }
        if (!attr0.getID().equalsIgnoreCase(attr1.getID())) {
            throw new IllegalArgumentException("Cannot take difference of attributes with different IDs!");
        }
        String id = attr0.getID();
        AttributeImpl attr = new AttributeImpl(id);
        if (attr0 != null) {
            for (ii = 0; ii < attr0.size(); ++ii) {
                attr.add(attr0.get(ii));
            }
        }
        if (attr1 != null) {
            for (ii = 0; ii < attr1.size(); ++ii) {
                attr.remove(attr1.get(ii));
            }
        }
        return attr;
    }

    public static Attribute getUnion(Attribute attr0, Attribute attr1) throws NamingException {
        int ii;
        String id;
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException("Cannot figure out attribute ID if both args are null");
        }
        if (attr0 == null) {
            id = attr1.getID();
        } else if (attr1 == null) {
            id = attr0.getID();
        } else {
            if (!attr0.getID().equalsIgnoreCase(attr1.getID())) {
                throw new IllegalArgumentException("Cannot take union of attributes with different IDs!");
            }
            id = attr0.getID();
        }
        AttributeImpl attr = new AttributeImpl(id);
        if (attr0 != null) {
            for (ii = 0; ii < attr0.size(); ++ii) {
                attr.add(attr0.get(ii));
            }
        }
        if (attr1 != null) {
            for (ii = 0; ii < attr1.size(); ++ii) {
                attr.add(attr1.get(ii));
            }
        }
        return attr;
    }

    public static Attributes toCaseInsensitive(Attributes attributes) {
        if (attributes == null) {
            return attributes;
        }
        if (attributes instanceof BasicAttributes) {
            if (attributes.isCaseIgnored()) {
                return attributes;
            }
            BasicAttributes newAttrs = new BasicAttributes(true);
            NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
            if (attrs != null) {
                while (attrs.hasMoreElements()) {
                    newAttrs.put((Attribute)attrs.nextElement());
                }
            }
            return newAttrs;
        }
        return attributes;
    }

    public static String toString(String tabs, Attribute attribute) {
        StringBuffer sb = new StringBuffer();
        sb.append(tabs).append("Attribute\n");
        if (attribute != null) {
            sb.append(tabs).append("    Type : '").append(attribute.getID()).append("'\n");
            for (int j = 0; j < attribute.size(); ++j) {
                try {
                    Object attr = attribute.get(j);
                    if (attr == null) continue;
                    if (attr instanceof String) {
                        sb.append(tabs).append("        Val[").append(j).append("] : ").append(attr).append(" \n");
                        continue;
                    }
                    if (attr instanceof byte[]) {
                        String string = StringTools.utf8ToString((byte[])attr);
                        sb.append(tabs).append("        Val[").append(j).append("] : ");
                        sb.append(string).append('/');
                        sb.append(StringTools.dumpBytes((byte[])attr));
                        sb.append(" \n");
                        continue;
                    }
                    sb.append(tabs).append("        Val[").append(j).append("] : ").append(attr).append(" \n");
                    continue;
                }
                catch (NamingException ne) {
                    sb.append("Bad attribute : ").append(ne.getMessage());
                }
            }
        }
        return sb.toString();
    }

    public static String toString(Attribute attribute) {
        return AttributeUtils.toString("", attribute);
    }

    public static String toString(String tabs, Attributes attributes) {
        StringBuffer sb = new StringBuffer();
        sb.append(tabs).append("Attributes\n");
        if (attributes != null) {
            NamingEnumeration<? extends Attribute> attributesIterator = attributes.getAll();
            while (attributesIterator.hasMoreElements()) {
                Attribute attribute = (Attribute)attributesIterator.nextElement();
                sb.append(tabs).append(attribute.toString());
            }
        }
        return sb.toString();
    }

    public static String toString(Attributes attributes) {
        return AttributeUtils.toString("", attributes);
    }
}

